/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.job;

import java.util.ArrayList;
import java.util.Map;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Request;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.job.WikiStreamJobRequest;
import org.xwiki.wikistream.type.WikiStreamType;

@Unstable
public class WikiStreamConverterJobRequest
extends AbstractRequest
implements WikiStreamJobRequest {
    private static final long serialVersionUID = 1L;
    private WikiStreamType inputType;
    private Map<String, Object> inputProperties;
    private WikiStreamType outputType;
    private Map<String, Object> outputProperties;

    public WikiStreamConverterJobRequest(WikiStreamType inputType, Map<String, Object> inputProperties, WikiStreamType outputType, Map<String, Object> outputProperties) {
        this.inputType = inputType;
        this.inputProperties = inputProperties;
        this.outputType = outputType;
        this.outputProperties = outputProperties;
        ArrayList<String> jobId = new ArrayList<String>();
        jobId.add("wikistream");
        jobId.add("converter");
        jobId.add(inputType.serialize());
        jobId.add(outputType.serialize());
        this.setId(jobId);
    }

    public WikiStreamConverterJobRequest(Request request) {
        super(request);
    }

    public WikiStreamType getInputType() {
        return this.inputType;
    }

    public Map<String, Object> getInputProperties() {
        return this.inputProperties;
    }

    public WikiStreamType getOutputType() {
        return this.outputType;
    }

    public Map<String, Object> getOutputProperties() {
        return this.outputProperties;
    }
}

