/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.model.filter;

import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.annotation.Default;
import org.xwiki.filter.annotation.Name;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.WikiStreamException;

/**
 * Object related events.
 * 
 * @version $Id: 4436f59af23f716aade4466f29c698a6c88bcffe $
 * @since 5.2M2
 */
@Unstable
public interface WikiObjectFilter
{
    /**
     * @type {@link Integer}
     */
    String PARAMETER_NUMBER = "number";

    /**
     * @type {@link String}
     */
    String PARAMETER_CLASS_REFERENCE = "class_reference";

    /**
     * @type {@link String}
     */
    String PARAMETER_GUID = "guid";

    /**
     * @param name the name of the object
     * @param parameters the properties of the object
     * @throws WikiStreamException when failing to send event
     */
    void beginWikiObject(@Name("name") String name,
        @Default(FilterEventParameters.DEFAULT) @Name(FilterEventParameters.NAME) FilterEventParameters parameters)
        throws WikiStreamException;

    /**
     * @param name the name of the object
     * @param parameters the properties of the object
     * @throws WikiStreamException when failing to send event
     */
    void endWikiObject(@Name("name") String name,
        @Default(FilterEventParameters.DEFAULT) @Name(FilterEventParameters.NAME) FilterEventParameters parameters)
        throws WikiStreamException;
}
