/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.instance.internal.output;

import org.xwiki.component.phase.Initializable;
import org.xwiki.wikistream.instance.output.OutputInstanceWikiStreamFactory;
import org.xwiki.wikistream.internal.output.AbstractBeanOutputWikiStreamFactory;
import org.xwiki.wikistream.type.WikiStreamType;

/**
 * @param <P> the type of the properties bean
 * @param <F> the type of the filter
 * @version $Id: ef5a9ca4068377a6a01ebbc42667304e2fd9b4cb $
 * @since 5.2
 */
public abstract class AbstractBeanOutputInstanceWikiStreamFactory<P, F> extends
    AbstractBeanOutputWikiStreamFactory<P, F> implements OutputInstanceWikiStreamFactory, Initializable
{
    /**
     * @param id the id of the {@link OutputInstanceWikiStreamFactory}
     */
    public AbstractBeanOutputInstanceWikiStreamFactory(String id)
    {
        super(new WikiStreamType(WikiStreamType.XWIKI_INSTANCE.getType(), WikiStreamType.XWIKI_INSTANCE.getDataFormat()
            + "+" + id));
    }
}
