/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.internal.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.BeanManager;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.instance.input.AbstractEntityEventGenerator;

public abstract class AbstractBeanEntityEventGenerator<E, F, P>
extends AbstractEntityEventGenerator<E, F> {
    @Inject
    private BeanManager beanManager;
    private Class<P> propertiesType;

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanEntityEventGenerator.class, this.getClass());
        this.propertiesType = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[2]);
    }

    @Override
    protected void write(E entity, Object filter, F internalFilter, Map<String, Object> properties) throws WikiStreamException {
        P propertiesBean;
        try {
            propertiesBean = this.propertiesType.newInstance();
            this.beanManager.populate(propertiesBean, properties);
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to convert properties to Java bean", (Throwable)e);
        }
        this.write(entity, filter, internalFilter, propertiesBean);
    }

    protected abstract void write(E var1, Object var2, F var3, P var4) throws WikiStreamException;
}

