/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.internal.input;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.instance.input.InstanceInputEventGenerator;
import org.xwiki.wikistream.instance.internal.InstanceFilter;
import org.xwiki.wikistream.instance.internal.InstanceModel;
import org.xwiki.wikistream.instance.internal.input.InstanceInputProperties;
import org.xwiki.wikistream.internal.input.AbstractBeanInputWikiStream;

@Component
@Named(value="xwiki+instance")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class InstanceInputWikiStream
extends AbstractBeanInputWikiStream<InstanceInputProperties, InstanceFilter> {
    @Inject
    private InstanceModel instanceModel;
    @Inject
    private List<InstanceInputEventGenerator> eventGenerators;

    public void setProperties(InstanceInputProperties properties) {
        super.setProperties((Object)properties);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setProperties((Map)this.properties);
        }
    }

    private boolean isWikiEnabled(String wiki) {
        return ((InstanceInputProperties)this.properties).getEntities() == null || ((InstanceInputProperties)this.properties).getEntities().matches((EntityReference)new WikiReference(wiki));
    }

    private boolean isSpaceEnabled(String wiki, String space) {
        return ((InstanceInputProperties)this.properties).getEntities() == null || ((InstanceInputProperties)this.properties).getEntities().matches((EntityReference)new SpaceReference(space, new WikiReference(wiki)));
    }

    private boolean isDocumentEnabled(String wiki, String space, String document) {
        return ((InstanceInputProperties)this.properties).getEntities() == null || ((InstanceInputProperties)this.properties).getEntities().matches((EntityReference)new DocumentReference(wiki, space, document));
    }

    public void close() throws IOException {
    }

    protected void read(Object filter, InstanceFilter proxyFilter) throws WikiStreamException {
        FilterEventParameters parameters = FilterEventParameters.EMPTY;
        proxyFilter.beginFarm(parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setFilter(filter);
            generator.beginFarm(parameters);
        }
        for (String wikiName : this.instanceModel.getWikis()) {
            if (!this.isWikiEnabled(wikiName)) continue;
            this.writeWiki(wikiName, filter, proxyFilter);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endFarm(parameters);
        }
        proxyFilter.endFarm(parameters);
    }

    private void writeWiki(String wiki, Object filter, InstanceFilter proxyFilter) throws WikiStreamException {
        FilterEventParameters parameters = FilterEventParameters.EMPTY;
        proxyFilter.beginWiki(wiki, parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.beginWiki(wiki, parameters);
        }
        for (String spaceName : this.instanceModel.getSpaces(wiki)) {
            if (!this.isSpaceEnabled(wiki, spaceName)) continue;
            this.writeSpace(wiki, spaceName, filter, proxyFilter);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWiki(wiki, parameters);
        }
        proxyFilter.endWiki(wiki, parameters);
    }

    private void writeSpace(String wiki, String space, Object filter, InstanceFilter proxyFilter) throws WikiStreamException {
        FilterEventParameters parameters = FilterEventParameters.EMPTY;
        proxyFilter.beginWikiSpace(space, parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.beginWikiSpace(space, parameters);
        }
        for (String documentName : this.instanceModel.getDocuments(wiki, space)) {
            if (!this.isDocumentEnabled(wiki, space, documentName)) continue;
            this.writeDocument(documentName, filter, proxyFilter);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWikiSpace(space, parameters);
        }
        proxyFilter.endWikiSpace(space, parameters);
    }

    private void writeDocument(String document, Object filter, InstanceFilter proxyFilter) throws WikiStreamException {
        FilterEventParameters parameters = FilterEventParameters.EMPTY;
        proxyFilter.beginWikiDocument(document, parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.beginWikiDocument(document, parameters);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWikiDocument(document, parameters);
        }
        proxyFilter.endWikiDocument(document, parameters);
    }
}

