/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.descriptor.WikiStreamDescriptor;
import org.xwiki.wikistream.instance.input.InstanceInputEventGenerator;

@Unstable
public abstract class AbstractInstanceInputEventGenerator<F>
implements InstanceInputEventGenerator,
Initializable {
    @Inject
    private FilterDescriptorManager filterDescriptorManager;
    private List<Class<?>> filerInterfaces;
    protected Map<String, Object> properties;
    protected Object filter;
    protected F proxyFilter;
    protected String currentWiki;
    protected Stack<String> currentSpaces = new Stack();
    protected EntityReference currentReference;
    protected WikiStreamDescriptor descriptor;

    public void initialize() throws InitializationException {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractInstanceInputEventGenerator.class, this.getClass());
        this.filerInterfaces = Arrays.asList(ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[0]));
    }

    @Override
    public WikiStreamDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(WikiStreamDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Collection<Class<?>> getFilterInterfaces() throws WikiStreamException {
        return this.filerInterfaces;
    }

    @Override
    public void setWikiFarmParameters(FilterEventParameters parameters) throws WikiStreamException {
    }

    @Override
    public void setWikiParameters(String name, FilterEventParameters parameters) throws WikiStreamException {
    }

    @Override
    public void setWikiSpaceParameters(String name, FilterEventParameters parameters) throws WikiStreamException {
    }

    @Override
    public void setWikiDocumentParameters(String name, FilterEventParameters parameters) throws WikiStreamException {
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void setFilter(Object filter) {
        this.filter = filter;
        this.proxyFilter = this.filterDescriptorManager.createFilterProxy(filter, this.filerInterfaces.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    public void beginFarm(FilterEventParameters parameters) throws WikiStreamException {
    }

    public void endFarm(FilterEventParameters parameters) throws WikiStreamException {
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentWiki = name;
        this.currentReference = new EntityReference(this.currentWiki, EntityType.WIKI);
    }

    public void endWiki(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentWiki = null;
        this.currentReference = this.currentReference.getParent();
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentSpaces.push(name);
        this.currentReference = new EntityReference(name, EntityType.SPACE, this.currentReference);
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentSpaces.pop();
        this.currentReference = this.currentReference.getParent();
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentReference = new EntityReference(name, EntityType.DOCUMENT, this.currentReference);
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentReference = this.currentReference.getParent();
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws WikiStreamException {
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws WikiStreamException {
    }

    public void beginWikiDocumentRevision(String version, FilterEventParameters parameters) throws WikiStreamException {
    }

    public void endWikiDocumentRevision(String version, FilterEventParameters parameters) throws WikiStreamException {
    }

    public void beginUnknwon(String id, FilterEventParameters parameters) throws FilterException {
    }

    public void endUnknwon(String id, FilterEventParameters parameters) throws FilterException {
    }

    public void onUnknwon(String id, FilterEventParameters parameters) throws FilterException {
    }
}

