/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.internal.input;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.descriptor.CompositeWikiStreamDescriptor;
import org.xwiki.wikistream.descriptor.WikiStreamDescriptor;
import org.xwiki.wikistream.instance.input.InstanceInputEventGenerator;
import org.xwiki.wikistream.instance.input.InstanceInputProperties;
import org.xwiki.wikistream.instance.internal.InstanceFilter;
import org.xwiki.wikistream.internal.input.AbstractBeanInputWikiStreamFactory;
import org.xwiki.wikistream.type.WikiStreamType;

@Component
@Named(value="xwiki+instance")
@Singleton
public class InstanceInputWikiStreamFactory
extends AbstractBeanInputWikiStreamFactory<InstanceInputProperties, InstanceFilter> {
    public static final String ROLEHINT = "xwiki+instance";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public InstanceInputWikiStreamFactory() {
        super(WikiStreamType.XWIKI_INSTANCE);
        this.setName("XWiki instance input stream");
        this.setDescription("Generates wiki events from XWiki instance.");
    }

    public void initialize() throws InitializationException {
        List eventGenerators;
        super.initialize();
        try {
            eventGenerators = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(InstanceInputEventGenerator.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to get registered instance of InstanceInputEventGenerator components", (Throwable)e);
        }
        WikiStreamDescriptor[] descriptors = new WikiStreamDescriptor[eventGenerators.size() + 1];
        descriptors[0] = this.descriptor;
        for (int i = 0; i < eventGenerators.size(); ++i) {
            descriptors[i + 1] = ((InstanceInputEventGenerator)eventGenerators.get(i)).getDescriptor();
        }
        this.setDescriptor((WikiStreamDescriptor)new CompositeWikiStreamDescriptor(this.descriptor.getName(), this.descriptor.getDescription(), descriptors));
    }

    public Collection<Class<?>> getFilterInterfaces() throws WikiStreamException {
        List eventGenerators;
        try {
            eventGenerators = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(InstanceInputEventGenerator.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException("Failed to get registered instance of InstanceInputEventGenerator components", (Throwable)e);
        }
        HashSet filters = new HashSet();
        for (InstanceInputEventGenerator generator : eventGenerators) {
            filters.addAll(generator.getFilterInterfaces());
        }
        return filters;
    }
}

