/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.descriptor.WikiStreamDescriptor;
import org.xwiki.wikistream.instance.input.EntityEventGenerator;

@Unstable
public abstract class AbstractEntityEventGenerator<E, F>
implements EntityEventGenerator<E>,
Initializable {
    @Inject
    private FilterDescriptorManager filterDescriptorManager;
    protected Class<F> filterType;
    protected WikiStreamDescriptor descriptor;

    public void initialize() throws InitializationException {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractEntityEventGenerator.class, this.getClass());
        this.filterType = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[1]);
    }

    @Override
    public WikiStreamDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(WikiStreamDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void write(E entity, Object filter, Map<String, Object> properties) throws WikiStreamException {
        Object internalFilter = this.filterDescriptorManager.createFilterProxy(filter, new Class[]{this.filterType});
        this.write(entity, filter, internalFilter, properties);
    }

    protected abstract void write(E var1, Object var2, F var3, Map<String, Object> var4) throws WikiStreamException;
}

