/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.wikixml.internal.input;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.stream.XMLEventWriter;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.UnknownFilter;
import org.xwiki.filter.xml.parser.XMLParserFactory;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.output.OutputWikiStreamFactory;
import org.xwiki.wikistream.type.WikiStreamType;
import org.xwiki.wikistream.wikixml.input.WikiXMLInputProperties;
import org.xwiki.wikistream.wikixml.internal.output.WikiXMLOutputWikiStreamFactory;
import org.xwiki.wikistream.xml.internal.input.AbstractXMLBeanInputWikiStreamFactory;

@Component
@Named(value="wiki+xml")
@Singleton
public class WikiXMLInputWikiStreamFactory
extends AbstractXMLBeanInputWikiStreamFactory<WikiXMLInputProperties, Object> {
    @Inject
    private XMLParserFactory parserFactory;
    @Inject
    private Provider<ComponentManager> contextComponentManager;

    public WikiXMLInputWikiStreamFactory() {
        super(WikiStreamType.WIKI_XML);
        this.setName("Generic XML output stream");
        this.setDescription("Generates wiki events from generic XML file.");
    }

    public Collection<Class<?>> getFilterInterfaces() throws WikiStreamException {
        List factories;
        try {
            factories = ((ComponentManager)this.contextComponentManager.get()).getInstanceList(OutputWikiStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException("Failed to lookup OutputWikiStreamFactory components instances", (Throwable)e);
        }
        HashSet filters = new HashSet();
        filters.add(UnknownFilter.class);
        for (OutputWikiStreamFactory factory : factories) {
            if (factory.getClass() == WikiXMLOutputWikiStreamFactory.class) continue;
            filters.addAll(factory.getFilterInterfaces());
        }
        return filters;
    }

    protected XMLEventWriter createXMLEventWriter(Object filter, WikiXMLInputProperties parameters) {
        return this.parserFactory.createXMLEventWriter(filter, null);
    }
}

