/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.io.ByteArrayInputStream;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.xar.internal.XARAttachmentModel;
import org.xwiki.wikistream.xar.internal.XARFilter;
import org.xwiki.wikistream.xar.internal.XARWikiStreamUtils;
import org.xwiki.wikistream.xar.internal.input.AbstractReader;
import org.xwiki.wikistream.xar.internal.input.XARXMLReader;

@Component
@Singleton
public class AttachmentReader
extends AbstractReader
implements XARXMLReader<WikiAttachment> {
    @Override
    public WikiAttachment read(XMLStreamReader xmlReader) throws XMLStreamException, WikiStreamException {
        WikiAttachment wikiAttachment = new WikiAttachment();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            String value = xmlReader.getElementText();
            XARWikiStreamUtils.EventParameter parameter = XARAttachmentModel.ATTACHMENT_PARAMETERS.get(elementName);
            if (parameter != null) {
                Object wsValue = this.convert(parameter.type, value);
                if (wsValue != null) {
                    wikiAttachment.parameters.put((Object)parameter.name, wsValue);
                }
            } else if ("filename".equals(elementName)) {
                wikiAttachment.name = value;
            } else if ("content".equals(elementName)) {
                wikiAttachment.content = Base64.decodeBase64((byte[])value.getBytes());
            }
            xmlReader.nextTag();
        }
        return wikiAttachment;
    }

    public static class WikiAttachment {
        public String name;
        public byte[] content;
        public FilterEventParameters parameters = new FilterEventParameters();

        public void send(XARFilter proxyFilter) throws WikiStreamException {
            proxyFilter.onWikiAttachment(this.name, new ByteArrayInputStream(this.content), Long.valueOf(this.content.length), this.parameters);
        }
    }
}

