/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.xar.input.XARInputProperties;
import org.xwiki.wikistream.xar.internal.XARDocumentModel;
import org.xwiki.wikistream.xar.internal.XARFilter;
import org.xwiki.wikistream.xar.internal.XARWikiStreamUtils;
import org.xwiki.wikistream.xar.internal.input.AbstractReader;
import org.xwiki.wikistream.xar.internal.input.AttachmentReader;
import org.xwiki.wikistream.xar.internal.input.ClassReader;
import org.xwiki.wikistream.xar.internal.input.SkipEntityException;
import org.xwiki.wikistream.xar.internal.input.WikiObjectReader;
import org.xwiki.wikistream.xar.internal.input.XARXMLReader;
import org.xwiki.wikistream.xml.input.XMLInputProperties;
import org.xwiki.wikistream.xml.internal.input.XMLInputWikiStreamUtils;

@Component(roles={DocumentLocaleReader.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentLocaleReader
extends AbstractReader {
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeResolver;
    @Inject
    private XARXMLReader<WikiObjectReader.WikiObject> objectReader;
    @Inject
    private XARXMLReader<ClassReader.WikiClass> classReader;
    @Inject
    private XARXMLReader<AttachmentReader.WikiAttachment> attachmentReader;
    private XARInputProperties properties;
    private String currentSpace;
    private FilterEventParameters currentSpaceParameters = FilterEventParameters.EMPTY;
    private String currentDocument;
    private Locale currentDocumentLocale;
    private String currentDocumentRevision;
    private FilterEventParameters currentDocumentParameters = new FilterEventParameters();
    private FilterEventParameters currentDocumentLocaleParameters = new FilterEventParameters();
    private FilterEventParameters currentDocumentRevisionParameters = new FilterEventParameters();
    private boolean sentBeginWikiSpace;
    private boolean sentBeginWikiDocument;
    private boolean sentBeginWikiDocumentLocale;
    private boolean sentBeginWikiDocumentRevision;
    private ClassReader.WikiClass currentClass = new ClassReader.WikiClass();
    private Queue<WikiObjectReader.WikiObject> currentObjects = new LinkedList<WikiObjectReader.WikiObject>();
    private Queue<AttachmentReader.WikiAttachment> currentAttachments = new LinkedList<AttachmentReader.WikiAttachment>();

    public void setProperties(XARInputProperties properties) {
        this.properties = properties;
    }

    public String getCurrentSpace() {
        return this.currentSpace;
    }

    public FilterEventParameters getCurrentSpaceParameters() {
        return this.currentSpaceParameters;
    }

    private void reset() {
        this.currentDocument = null;
        this.currentDocumentLocale = null;
        this.currentDocumentRevision = null;
        this.currentDocumentParameters = new FilterEventParameters();
        this.currentDocumentLocaleParameters = new FilterEventParameters();
        this.currentDocumentRevisionParameters = new FilterEventParameters();
        this.sentBeginWikiDocument = false;
        this.sentBeginWikiDocumentLocale = false;
        this.sentBeginWikiDocumentRevision = false;
    }

    private boolean canSendBeginWikiSpace(boolean force) {
        return !this.sentBeginWikiSpace && (force || this.properties.getEntities() == null);
    }

    private void sendBeginWikiSpace(XARFilter proxyFilter, boolean force) throws WikiStreamException {
        if (this.canSendBeginWikiSpace(force)) {
            proxyFilter.beginWikiSpace(this.currentSpace, this.currentSpaceParameters);
            this.sentBeginWikiSpace = true;
        }
    }

    private void sendEndWikiSpace(XARFilter proxyFilter) throws WikiStreamException {
        proxyFilter.endWikiSpace(this.currentSpace, this.currentSpaceParameters);
        this.sentBeginWikiSpace = false;
    }

    private boolean canSendBeginWikiDocument(boolean force) {
        return this.sentBeginWikiSpace && !this.sentBeginWikiDocument && (force || this.currentDocument != null && this.currentDocumentParameters.size() == XARDocumentModel.DOCUMENT_PARAMETERS.size() && this.properties.getEntities() == null);
    }

    private void sendBeginWikiDocument(XARFilter proxyFilter, boolean force) throws WikiStreamException {
        this.sendBeginWikiSpace(proxyFilter, force);
        if (this.canSendBeginWikiDocument(force)) {
            this.sendBeginWikiSpace(proxyFilter, true);
            proxyFilter.beginWikiDocument(this.currentDocument, this.currentDocumentParameters);
            this.sentBeginWikiDocument = true;
        }
    }

    private void sendEndWikiDocument(XARFilter proxyFilter) throws WikiStreamException {
        this.sendBeginWikiDocument(proxyFilter, true);
        this.sendEndWikiDocumentLocale(proxyFilter);
        proxyFilter.endWikiDocument(this.currentDocument, this.currentDocumentParameters);
        this.sentBeginWikiDocument = false;
    }

    private boolean canSendBeginWikiDocumentLocale(boolean force) {
        return this.sentBeginWikiDocument && !this.sentBeginWikiDocumentLocale && (force || this.currentDocumentLocale != null && this.currentDocumentLocaleParameters.size() == XARDocumentModel.DOCUMENTLOCALE_PARAMETERS.size());
    }

    private void sendBeginWikiDocumentLocale(XARFilter proxyFilter, boolean force) throws WikiStreamException {
        if (force || this.currentSpace != null && this.currentDocument != null && this.currentDocumentLocale != null) {
            LocalDocumentReference reference = new LocalDocumentReference(this.currentSpace, this.currentDocument, this.currentDocumentLocale);
            if (this.properties.getEntities() != null && !this.properties.getEntities().matches((EntityReference)reference)) {
                throw new SkipEntityException((EntityReference)reference);
            }
            this.sendBeginWikiDocument(proxyFilter, force);
            if (this.canSendBeginWikiDocumentLocale(force)) {
                if (!this.properties.isWithHistory()) {
                    this.currentDocumentLocaleParameters.remove((Object)"xwiki_jrcsrevisions");
                }
                proxyFilter.beginWikiDocumentLocale(this.currentDocumentLocale, this.currentDocumentLocaleParameters);
                this.sentBeginWikiDocumentLocale = true;
            }
        }
    }

    private void sendEndWikiDocumentLocale(XARFilter proxyFilter) throws WikiStreamException {
        this.sendBeginWikiDocumentLocale(proxyFilter, true);
        this.sendEndWikiDocumentRevision(proxyFilter);
        proxyFilter.endWikiDocumentLocale(this.currentDocumentLocale, this.currentDocumentLocaleParameters);
        this.sentBeginWikiDocumentLocale = false;
    }

    private boolean canSendBeginWikiDocumentRevision(boolean force) {
        return this.sentBeginWikiDocumentLocale && !this.sentBeginWikiDocumentRevision && (force || this.currentDocumentRevision != null && this.currentDocumentRevisionParameters.size() == XARDocumentModel.DOCUMENTREVISION_PARAMETERS.size());
    }

    private void sendBeginWikiDocumentRevision(XARFilter proxyFilter, boolean force) throws WikiStreamException {
        this.sendBeginWikiDocumentLocale(proxyFilter, force);
        if (this.canSendBeginWikiDocumentRevision(force)) {
            proxyFilter.beginWikiDocumentRevision(this.currentDocumentRevision, this.currentDocumentRevisionParameters);
            this.sentBeginWikiDocumentRevision = true;
        }
    }

    private void sendEndWikiDocumentRevision(XARFilter proxyFilter) throws WikiStreamException {
        this.sendBeginWikiDocumentRevision(proxyFilter, true);
        proxyFilter.endWikiDocumentRevision(this.currentDocumentRevision, this.currentDocumentRevisionParameters);
        this.sentBeginWikiDocumentRevision = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Object filter, XARFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException, ParseException {
        XMLStreamReader xmlReader = XMLInputWikiStreamUtils.createXMLStreamReader((XMLInputProperties)this.properties);
        try {
            this.read(xmlReader, filter, proxyFilter);
        }
        finally {
            this.properties.getSource().close();
        }
    }

    public void read(InputStream stream, Object filter, XARFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException, ParseException {
        XMLStreamReader xmlReader = this.properties.getEncoding() != null ? XMLInputFactory.newInstance().createXMLStreamReader(stream, this.properties.getEncoding()) : XMLInputFactory.newInstance().createXMLStreamReader(stream);
        this.read(xmlReader, filter, proxyFilter);
    }

    public void read(XMLStreamReader xmlReader, Object filter, XARFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException, ParseException {
        this.reset();
        xmlReader.nextTag();
        xmlReader.require(1, null, "xwikidoc");
        this.readDocument(xmlReader, filter, proxyFilter);
    }

    private void readDocument(XMLStreamReader xmlReader, Object filter, XARFilter proxyFilter) throws XMLStreamException, WikiStreamException, ParseException, IOException {
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            if (elementName.equals("attachment")) {
                this.readAttachment(xmlReader, filter, proxyFilter);
            } else if (elementName.equals("object")) {
                this.readObject(xmlReader, filter, proxyFilter);
            } else if (elementName.equals("class")) {
                this.readClass(xmlReader, filter, proxyFilter);
            } else {
                String value = xmlReader.getElementText();
                if ("web".equals(elementName)) {
                    if (!value.equals(this.currentSpace)) {
                        if (this.currentSpace != null) {
                            this.sendEndWikiSpace(proxyFilter);
                        }
                        this.currentSpace = value;
                        this.sendBeginWikiSpace(proxyFilter, false);
                    }
                } else if ("name".equals(elementName)) {
                    this.currentDocument = value;
                } else if ("language".equals(elementName)) {
                    this.currentDocumentLocale = (Locale)this.convert(Locale.class, value);
                } else if ("version".equals(elementName)) {
                    this.currentDocumentRevision = value;
                } else {
                    Object wsValue;
                    XARWikiStreamUtils.EventParameter parameter = XARDocumentModel.DOCUMENT_PARAMETERS.get(elementName);
                    if (parameter != null) {
                        wsValue = this.convert(parameter.type, value);
                        if (wsValue != null) {
                            this.currentDocumentParameters.put((Object)parameter.name, wsValue);
                        }
                    } else {
                        parameter = XARDocumentModel.DOCUMENTLOCALE_PARAMETERS.get(elementName);
                        if (parameter != null) {
                            wsValue = this.convert(parameter.type, value);
                            if (wsValue != null) {
                                this.currentDocumentLocaleParameters.put((Object)parameter.name, wsValue);
                            }
                        } else {
                            Object objectValue;
                            parameter = XARDocumentModel.DOCUMENTREVISION_PARAMETERS.get(elementName);
                            if (parameter != null && (objectValue = parameter.type == EntityReference.class ? this.relativeResolver.resolve((Object)value, EntityType.DOCUMENT, new Object[0]) : this.convert(parameter.type, value)) != null) {
                                this.currentDocumentRevisionParameters.put((Object)parameter.name, objectValue);
                            }
                        }
                    }
                }
            }
            xmlReader.nextTag();
        }
        this.sendBeginWikiDocumentRevision(proxyFilter, true);
        this.sendWikiAttachments(proxyFilter);
        this.sendWikiClass(proxyFilter);
        this.sendWikiObjects(proxyFilter);
        this.sendEndWikiDocument(proxyFilter);
    }

    private void readObject(XMLStreamReader xmlReader, Object filter, XARFilter proxyFilter) throws XMLStreamException, WikiStreamException, IOException, ParseException {
        this.sendBeginWikiDocumentRevision(proxyFilter, false);
        WikiObjectReader.WikiObject wikiObject = this.objectReader.read(xmlReader);
        if (this.sentBeginWikiDocumentRevision) {
            wikiObject.send(proxyFilter);
        } else {
            this.currentObjects.offer(wikiObject);
        }
    }

    private void readClass(XMLStreamReader xmlReader, Object filter, XARFilter proxyFilter) throws XMLStreamException, WikiStreamException, IOException, ParseException {
        this.sendBeginWikiDocumentRevision(proxyFilter, false);
        this.currentClass = this.classReader.read(xmlReader);
        if (this.sentBeginWikiDocumentRevision) {
            this.sendWikiClass(proxyFilter);
        }
    }

    private void readAttachment(XMLStreamReader xmlReader, Object filter, XARFilter proxyFilter) throws XMLStreamException, WikiStreamException, ParseException {
        this.sendBeginWikiDocumentRevision(proxyFilter, false);
        AttachmentReader.WikiAttachment wikiAttachment = this.attachmentReader.read(xmlReader);
        if (this.sentBeginWikiDocumentRevision) {
            wikiAttachment.send(proxyFilter);
        } else {
            this.currentAttachments.offer(wikiAttachment);
        }
    }

    private void sendWikiClass(XARFilter proxyFilter) throws WikiStreamException {
        if (this.currentClass != null && !this.currentClass.isEmpty()) {
            this.currentClass.send(proxyFilter);
            this.currentClass = null;
        }
    }

    private void sendWikiObjects(XARFilter proxyFilter) throws WikiStreamException {
        while (this.currentObjects.size() > 0) {
            this.currentObjects.poll().send(proxyFilter);
        }
    }

    private void sendWikiAttachments(XARFilter proxyFilter) throws WikiStreamException {
        while (this.currentAttachments.size() > 0) {
            this.currentAttachments.poll().send(proxyFilter);
        }
    }
}

