/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.output;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.output.FileOutputTarget;
import org.xwiki.wikistream.output.OutputStreamOutputTarget;
import org.xwiki.wikistream.output.OutputTarget;
import org.xwiki.wikistream.xar.output.XAROutputProperties;
import org.xwiki.xar.XarPackage;

public class XARWikiWriter {
    private final String name;
    private final XAROutputProperties xarProperties;
    private final ZipArchiveOutputStream zipStream;
    private XarPackage xarPackage;

    public XARWikiWriter(String name, XAROutputProperties xarProperties) throws WikiStreamException {
        block4: {
            this.xarPackage = new XarPackage();
            this.name = name;
            this.xarProperties = xarProperties;
            OutputTarget target = this.xarProperties.getTarget();
            try {
                if (target instanceof FileOutputTarget && ((FileOutputTarget)target).getFile().isDirectory()) {
                    this.zipStream = new ZipArchiveOutputStream(new File(((FileOutputTarget)target).getFile(), name + ".xar"));
                    break block4;
                }
                if (target instanceof OutputStreamOutputTarget) {
                    this.zipStream = new ZipArchiveOutputStream(((OutputStreamOutputTarget)target).getOutputStream());
                    break block4;
                }
                throw new WikiStreamException(String.format("Unsupported output target [%s]. Only [%s] is supported", target, OutputStreamOutputTarget.class));
            }
            catch (IOException e) {
                throw new WikiStreamException("Failed to create zip output stream", (Throwable)e);
            }
        }
        this.zipStream.setEncoding("UTF8");
        this.zipStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
    }

    public String getName() {
        return this.name;
    }

    public OutputStream newEntry(LocalDocumentReference reference) throws WikiStreamException {
        StringBuilder path = new StringBuilder();
        path.append(reference.getParent().getName()).append('/');
        path.append(reference.getName());
        if (reference.getLocale() != null && !reference.getLocale().equals(Locale.ROOT)) {
            path.append('.');
            path.append(reference.getLocale());
        }
        path.append(".xml");
        ZipArchiveEntry zipentry = new ZipArchiveEntry(path.toString());
        try {
            this.zipStream.putArchiveEntry((ArchiveEntry)zipentry);
        }
        catch (IOException e) {
            throw new WikiStreamException("Failed to add a new zip entry for [" + path + "]", (Throwable)e);
        }
        this.xarPackage.addEntry(reference);
        return this.zipStream;
    }

    public void closeEntry() throws WikiStreamException {
        try {
            this.zipStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new WikiStreamException("Failed to close zip archive entry", (Throwable)e);
        }
    }

    private void writePackage() throws WikiStreamException {
        try {
            this.xarPackage.write(this.zipStream, this.xarProperties.getEncoding());
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to write package.xml entry", (Throwable)e);
        }
    }

    public void close() throws WikiStreamException {
        this.writePackage();
        try {
            this.zipStream.close();
        }
        catch (IOException e) {
            throw new WikiStreamException("Failed to close zip output stream", (Throwable)e);
        }
    }
}

