/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.xar.internal.input;

import org.xwiki.model.reference.EntityReference;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.WikiStreamException;

/**
 * Used to indicate that the parsed entity should be skipped.
 * 
 * @version $Id: bec6c400836f2b1230f55c3506d097ce35b96b43 $
 */
@Unstable
public class SkipEntityException extends WikiStreamException
{
    /**
     * Class version.
     */
    private static final long serialVersionUID = 1L;

    /**
     * @see #getEntityReference()
     */
    private final EntityReference entityReference;

    /**
     * @param entityReference the skipped entity
     */
    public SkipEntityException(EntityReference entityReference)
    {
        super("Skip " + entityReference);

        this.entityReference = entityReference;
    }

    /**
     * @return the skipped entity
     */
    public EntityReference getEntityReference()
    {
        return this.entityReference;
    }
}
