/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.InputSource;
import org.xwiki.wikistream.input.InputStreamInputSource;
import org.xwiki.wikistream.xar.input.XARInputProperties;
import org.xwiki.wikistream.xar.internal.XARFilter;
import org.xwiki.wikistream.xar.internal.input.DocumentLocaleReader;
import org.xwiki.wikistream.xar.internal.input.SkipEntityException;
import org.xwiki.xar.XarPackage;

@Component(roles={WikiReader.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiReader {
    @Inject
    private DocumentLocaleReader documentReader;
    private XARInputProperties properties;
    private XarPackage xarPackage = new XarPackage();

    public void setProperties(XARInputProperties properties) {
        this.properties = properties;
        this.documentReader.setProperties(properties);
    }

    public XarPackage getXarPackage() {
        return this.xarPackage;
    }

    public void read(Object filter, XARFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException {
        InputSource source = this.properties.getSource();
        if (!(source instanceof InputStreamInputSource)) {
            throw new WikiStreamException("Unsupported source type [" + source.getClass() + "]");
        }
        InputStream stream = ((InputStreamInputSource)source).getInputStream();
        this.read(stream, filter, proxyFilter);
        if (this.documentReader.getCurrentSpace() != null) {
            proxyFilter.endWikiSpace(this.documentReader.getCurrentSpace(), this.documentReader.getCurrentSpaceParameters());
        }
        if (this.xarPackage.getPackageExtensionId() != null) {
            // empty if block
        }
    }

    public void read(InputStream stream, Object filter, XARFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException {
        ZipArchiveInputStream zis = new ZipArchiveInputStream(stream, "UTF-8", false);
        ZipArchiveEntry entry = zis.getNextZipEntry();
        while (entry != null) {
            if (!entry.isDirectory() && !entry.getName().startsWith("META-INF")) {
                if (entry.getName().equals("package.xml")) {
                    try {
                        this.xarPackage.readDescriptor((InputStream)zis);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        this.documentReader.read((InputStream)zis, filter, proxyFilter);
                    }
                    catch (SkipEntityException skip) {
                    }
                    catch (Exception e) {
                        throw new WikiStreamException(String.format("Failed to read XAR XML document from entry [%s]", entry.getName()), (Throwable)e);
                    }
                }
            }
            entry = zis.getNextZipEntry();
        }
    }
}

