/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.test.integration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.wikistream.internal.input.DefaultURLInputSource;
import org.xwiki.wikistream.internal.input.StringInputSource;
import org.xwiki.wikistream.test.integration.ExpectTestConfiguration;
import org.xwiki.wikistream.test.integration.InputTestConfiguration;
import org.xwiki.wikistream.test.integration.OutputTestConfiguration;
import org.xwiki.wikistream.test.integration.TestResourceData;

public class TestDataParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResourceData parse(InputStream source, String resourceName) throws IOException {
        TestResourceData data = new TestResourceData();
        BufferedReader reader = new BufferedReader(new InputStreamReader(source, "UTF-8"));
        try {
            String action = null;
            String typeId = null;
            boolean skip = false;
            data.resourceName = resourceName;
            StringBuilder buffer = new StringBuilder();
            Map<String, String> configuration = data.configuration;
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(".")) {
                    StringTokenizer st;
                    if (line.startsWith(".#")) {
                        if (line.toLowerCase().contains("todo")) {
                            System.out.println(line);
                        }
                    } else if (line.startsWith(".configuration")) {
                        st = new StringTokenizer(line.substring(".configuration".length() + 1), "=");
                        configuration.put(st.nextToken(), st.nextToken());
                    } else {
                        if (!skip) {
                            this.saveData(data, action, typeId, buffer, configuration);
                        }
                        buffer.setLength(0);
                        configuration = new HashMap<String, String>();
                        st = new StringTokenizer(line.substring(1), "|");
                        action = st.nextToken();
                        typeId = st.nextToken();
                        skip = false;
                        if (st.hasMoreTokens()) {
                            skip = true;
                            System.out.println("[WARNING] Skipping test for [" + typeId + "] in resource [" + resourceName + "] since it has been marked as skipped in the test. This needs to be " + "reviewed and fixed.");
                        }
                    }
                } else {
                    buffer.append(line).append('\n');
                }
                line = reader.readLine();
            }
            if (!skip) {
                this.saveData(data, action, typeId, buffer, configuration);
            }
        }
        finally {
            reader.close();
        }
        return data;
    }

    private void saveData(TestResourceData data, String action, String typeId, StringBuilder buffer, Map<String, String> configuration) {
        if (action != null) {
            if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
                buffer.setLength(buffer.length() - 1);
            }
            if (action.equalsIgnoreCase("input")) {
                this.addInput(data, typeId, buffer, configuration);
            } else if (action.equalsIgnoreCase("expect")) {
                this.addExpect(data, typeId, buffer, configuration);
            } else if (action.equalsIgnoreCase("inputexpect")) {
                this.addExpect(data, typeId, buffer, configuration);
                this.addInput(data, typeId, buffer, configuration);
            }
        }
    }

    private void addInput(TestResourceData data, String typeId, StringBuilder buffer, Map<String, String> configuration) {
        StringInputSource source;
        InputTestConfiguration inputConfiguration = new InputTestConfiguration(typeId, buffer.toString());
        inputConfiguration.setEncoding("UTF-8");
        inputConfiguration.putAll(configuration);
        String expectPath = configuration.get("source");
        if (expectPath == null) {
            source = new StringInputSource(buffer.toString());
        } else {
            if (!expectPath.startsWith("/")) {
                expectPath = StringUtils.substringBeforeLast((String)data.resourceName, (String)"/") + '/' + expectPath;
            }
            source = new DefaultURLInputSource(this.getClass().getResource(expectPath));
        }
        inputConfiguration.put("source", source);
        data.inputs.add(inputConfiguration);
    }

    private void addExpect(TestResourceData data, String typeId, StringBuilder buffer, Map<String, String> configuration) {
        StringInputSource expect;
        ExpectTestConfiguration expectTestConfiguration = new ExpectTestConfiguration();
        String expectPath = configuration.get("source");
        if (expectPath == null) {
            expect = new StringInputSource(buffer.toString());
        } else {
            if (!expectPath.startsWith("/")) {
                expectPath = StringUtils.substringBeforeLast((String)data.resourceName, (String)"/") + '/' + expectPath;
            }
            expect = new DefaultURLInputSource(this.getClass().getResource(expectPath));
        }
        expectTestConfiguration.expect = expect;
        OutputTestConfiguration outputConfiguration = new OutputTestConfiguration(typeId);
        outputConfiguration.setEncoding("UTF-8");
        outputConfiguration.setFormat(true);
        outputConfiguration.putAll(configuration);
        expectTestConfiguration.output = outputConfiguration;
        data.expects.add(expectTestConfiguration);
    }
}

