/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.importer;

import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;

@Component(roles={OfficeMacroImporter.class})
@Singleton
public class OfficeMacroImporter {
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="macro")
    private Transformation macroTransformation;
    @Inject
    @Named(value="annotatedxhtml/1.0")
    private BlockRenderer xhtmlRenderer;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public XDOM buildXDOM(AttachmentReference attachmentReference, boolean filterStyles) {
        HashMap<String, String> macroParams = new HashMap<String, String>();
        macroParams.put("attachment", attachmentReference.getName());
        if (!filterStyles) {
            macroParams.put("filterStyles", "false");
        }
        MacroBlock officeMacro = new MacroBlock("office", macroParams, false);
        XDOM xdom = new XDOM(Collections.singletonList(officeMacro));
        xdom.getMetaData().addMetaData("base", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference.getDocumentReference(), new Object[0]));
        try {
            DocumentModelBridge document = this.documentAccessBridge.getTranslatedDocumentInstance(attachmentReference.getDocumentReference());
            xdom.getMetaData().addMetaData("syntax", (Object)document.getSyntax());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to compute Syntax for the document containing attachment [%s]", attachmentReference), e);
        }
        return xdom;
    }

    public String render(XDOM xdom) throws Exception {
        TransformationContext txContext = new TransformationContext();
        txContext.setXDOM(xdom);
        ((MutableRenderingContext)this.renderingContext).transformInContext(this.macroTransformation, txContext, (Block)xdom);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
        return printer.toString();
    }
}

