/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.cleaner;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.wysiwyg.cleaner.HTMLCleaner;
import org.xwiki.wysiwyg.internal.cleaner.HTMLFilter;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
public class DefaultHTMLCleaner
implements HTMLCleaner {
    @Inject
    private org.xwiki.xml.html.HTMLCleaner cleaner;
    @Inject
    private List<HTMLFilter> specificFilters;

    @Override
    public String clean(String dirtyHTML) {
        Collections.sort(this.specificFilters, new Comparator<HTMLFilter>(){

            @Override
            public int compare(HTMLFilter alice, HTMLFilter bob) {
                return alice.getPriority() - bob.getPriority();
            }
        });
        HTMLCleanerConfiguration config = this.cleaner.getDefaultConfiguration();
        ArrayList<HTMLFilter> filters = new ArrayList<HTMLFilter>();
        filters.addAll(this.specificFilters);
        filters.addAll(config.getFilters());
        config.setFilters(filters);
        Document document = this.cleaner.clean((Reader)new StringReader(dirtyHTML), config);
        return HTMLUtils.toString((Document)document);
    }
}

