/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wysiwyg.importer.AttachmentImporter;
import org.xwiki.wysiwyg.internal.importer.OfficeMacroImporter;

@Component
@Singleton
@Named(value="office")
public class OfficeAttachmentImporter
implements AttachmentImporter {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private PresentationBuilder presentationBuilder;
    @Inject
    private XDOMOfficeDocumentBuilder documentBuilder;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private OfficeMacroImporter officeMacroImporter;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @Override
    public String toHTML(AttachmentReference attachmentReference, Map<String, Object> parameters) throws Exception {
        boolean filterStyles = Boolean.valueOf(String.valueOf(parameters.get("filterStyles")));
        if (Boolean.valueOf(String.valueOf(parameters.get("useOfficeViewer"))).booleanValue()) {
            return this.officeMacroImporter.render(this.officeMacroImporter.buildXDOM(attachmentReference, filterStyles));
        }
        return this.maybeConvertAttachmentContent(attachmentReference, filterStyles);
    }

    private String maybeConvertAttachmentContent(AttachmentReference attachmentReference, boolean filterStyles) throws Exception {
        if (this.authorization.hasAccess(Right.EDIT, (EntityReference)attachmentReference)) {
            if (this.documentAccessBridge.getAttachmentVersion(attachmentReference) != null) {
                if (this.officeServer.getState() == OfficeServer.ServerState.CONNECTED) {
                    return this.convertAttachmentContent(attachmentReference, filterStyles);
                }
                throw new RuntimeException(String.format("The office server is not connected.", new Object[0]));
            }
            throw new RuntimeException(String.format("Attachment not found: [%s].", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0])));
        }
        throw new RuntimeException(String.format("Edit right is required in order to import [%s].", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0])));
    }

    private String convertAttachmentContent(AttachmentReference attachmentReference, boolean filterStyles) throws Exception {
        InputStream officeFileStream = this.documentAccessBridge.getAttachmentContent(attachmentReference);
        String officeFileName = attachmentReference.getName();
        DocumentReference targetDocRef = attachmentReference.getDocumentReference();
        XDOMOfficeDocument xdomOfficeDocument = this.isPresentation(attachmentReference.getName()) ? this.presentationBuilder.build(officeFileStream, officeFileName, targetDocRef) : this.documentBuilder.build(officeFileStream, officeFileName, targetDocRef, filterStyles);
        for (File artifact : xdomOfficeDocument.getArtifactsFiles()) {
            AttachmentReference artifactReference = new AttachmentReference(artifact.getName(), targetDocRef);
            FileInputStream fis = new FileInputStream(artifact);
            Throwable throwable = null;
            try {
                this.documentAccessBridge.setAttachmentContent(artifactReference, IOUtils.toByteArray((InputStream)fis));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fis == null) continue;
                if (throwable != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fis.close();
            }
        }
        String result = xdomOfficeDocument.getContentAsString("annotatedxhtml/1.0");
        xdomOfficeDocument.close();
        return result;
    }

    private boolean isPresentation(String fileName) {
        if (this.officeServer.getConverter() != null) {
            return this.officeServer.getConverter().isPresentation(fileName);
        }
        return false;
    }
}

