/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageWizard;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractEntityListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class CurrentPageImageSelectorWizardStep
extends AbstractEntityListSelectorWizardStep<ImageConfig, Attachment>
implements SelectionHandler<ListItem<Attachment>> {
    private final ListItem<Attachment> clearFloatsListItem;
    private final boolean useLinkDestination;
    private final WikiServiceAsync wikiService;

    public CurrentPageImageSelectorWizardStep(WikiServiceAsync wikiService, boolean useLinkDestination) {
        this.wikiService = wikiService;
        this.useLinkDestination = useLinkDestination;
        this.setStepTitle(Strings.INSTANCE.imageSelectImageTitle());
        this.display().addStyleName("xImagesSelector");
        this.clearFloatsListItem = new ListItem();
        this.clearFloatsListItem.setStyleName("clearfloats");
        this.getList().addSelectionHandler((SelectionHandler)this);
    }

    @Override
    protected String getSelectHelpLabel() {
        return Strings.INSTANCE.imageSelectImageHelpLabel();
    }

    @Override
    protected String getSelectErrorMessage() {
        return Strings.INSTANCE.imageNoImageSelectedError();
    }

    @Override
    protected void fetchData(AsyncCallback<List<Attachment>> callback) {
        EntityReference currentPage = this.useLinkDestination ? ((EntityLink)this.getData()).getDestination().getEntityReference() : ((EntityLink)this.getData()).getOrigin();
        this.wikiService.getImageAttachments(new WikiPageReference(currentPage), callback);
    }

    @Override
    protected ListItem<Attachment> fillList(List<Attachment> attachments, Attachment selectedAttachment) {
        ListItem<Attachment> selectedItem = super.fillList(attachments, selectedAttachment);
        this.getList().addItem(this.clearFloatsListItem);
        return selectedItem;
    }

    public String getNextStep() {
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() == null) {
            return ImageWizard.ImageWizardStep.IMAGE_UPLOAD.toString();
        }
        return ImageWizard.ImageWizardStep.IMAGE_CONFIG.toString();
    }

    @Override
    protected ListItem<Attachment> getListItem(Attachment image) {
        ListItem imageItem = new ListItem();
        imageItem.setData((Object)image);
        Image htmlImage = new Image(image.getUrl() + "?width=135");
        htmlImage.setTitle(new AttachmentReference(image.getReference()).getFileName());
        FlowPanel previewPanel = new FlowPanel();
        previewPanel.addStyleName("xImagePreview");
        previewPanel.add((Widget)htmlImage);
        imageItem.add((Widget)previewPanel);
        return imageItem;
    }

    @Override
    protected ListItem<Attachment> getNewOptionListItem() {
        ListItem newImageOption = new ListItem();
        newImageOption.setData(null);
        FlowPanel newOptionPanel = new FlowPanel();
        newOptionPanel.addStyleName("xNewImagePreview");
        Label newOptionLabel = new Label(Strings.INSTANCE.imageUploadNewFileLabel());
        newOptionPanel.add((Widget)newOptionLabel);
        newImageOption.add((Widget)newOptionPanel);
        return newImageOption;
    }

    public void onSelection(SelectionEvent<ListItem<Attachment>> event) {
        if (event.getSelectedItem() == this.clearFloatsListItem) {
            this.getList().setSelectedItem(this.getList().getItem(this.getList().getItemCount() - 2));
        }
    }

    @Override
    protected void saveSelectedValue(AsyncCallback<Boolean> async) {
        ((EntityLink)this.getData()).getDestination().setType(ResourceReference.ResourceType.ATTACHMENT);
        super.saveSelectedValue(async);
    }
}

