/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.UIObject;
import org.xwiki.gwt.user.client.RichTextAreaCommand;
import org.xwiki.gwt.user.client.ui.MenuItem;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.MenuItemUIExtensionAdaptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroPluginFactory;

public class MacroMenuExtension
extends MenuItemUIExtensionAdaptor {
    private MenuItem collapse;
    private MenuItem expand;
    private MenuItem edit;
    private MenuItem insert;
    private final MacroPlugin plugin;

    public MacroMenuExtension(final MacroPlugin plugin) {
        super("menu");
        this.setShortcutKeyManager(plugin.getShortcutKeyManager());
        this.plugin = plugin;
        MenuItem refresh = this.createMenuItem(Strings.INSTANCE.macroRefresh(), Strings.INSTANCE.macroRefreshShortcutKeyLabel(), Images.INSTANCE.macroRefresh(), (Command)new RichTextAreaCommand(plugin.getTextArea(), MacroPlugin.REFRESH, null, false), 'R');
        this.collapse = this.createMenuItem(Strings.INSTANCE.macroCollapseAll(), Strings.INSTANCE.macroCollapseAllShortcutKeyLabel(), null, (Command)new RichTextAreaCommand(plugin.getTextArea(), MacroPlugin.COLLAPSE), 'C');
        this.expand = this.createMenuItem(Strings.INSTANCE.macroExpandAll(), Strings.INSTANCE.macroExpandAllShortcutKeyLabel(), null, (Command)new RichTextAreaCommand(plugin.getTextArea(), MacroPlugin.EXPAND), 'E');
        this.edit = this.createMenuItem(Strings.INSTANCE.macroEdit(), Strings.INSTANCE.macroEditShortcutKeyLabel(), Images.INSTANCE.macroEdit(), new Command(){

            public void execute() {
                plugin.edit();
            }
        }, '\u0000');
        this.insert = this.createMenuItem(Strings.INSTANCE.macroInsert(), Strings.INSTANCE.macroInsertShortcutKeyLabel(), Images.INSTANCE.macroInsert(), new Command(){

            public void execute() {
                if (plugin.getSelector().getMacroCount() <= 0) {
                    plugin.insert();
                }
            }
        }, 'M');
        MenuItem macroMenu = this.createMenuItem(Strings.INSTANCE.macro(), Images.INSTANCE.macro());
        this.addFeature(MacroPluginFactory.getInstance().getPluginName(), (UIObject)macroMenu);
        this.addFeature("macroRefresh", (UIObject)refresh);
        this.addFeature("macroCollapse", (UIObject)this.collapse);
        this.addFeature("macroExpand", (UIObject)this.expand);
        this.addFeature("macroEdit", (UIObject)this.edit);
        this.addFeature("macroInsert", (UIObject)this.insert);
    }

    protected void onAttach(AttachEvent event) {
        boolean editMode = this.plugin.getTextArea().getCommandManager().isExecuted(MacroPlugin.INSERT);
        if (this.collapse.getParentMenu() == event.getSource()) {
            this.collapse.setEnabled(!this.plugin.getTextArea().getCommandManager().isExecuted(MacroPlugin.COLLAPSE));
            if (editMode) {
                this.collapse.setText(Strings.INSTANCE.macroCollapse());
                this.collapse.setShortcutKeyLabel(Strings.INSTANCE.macroCollapseShortcutKeyLabel());
            } else {
                this.collapse.setText(Strings.INSTANCE.macroCollapseAll());
                this.collapse.setShortcutKeyLabel(Strings.INSTANCE.macroCollapseAllShortcutKeyLabel());
            }
        }
        if (this.expand.getParentMenu() == event.getSource()) {
            this.expand.setEnabled(!this.plugin.getTextArea().getCommandManager().isExecuted(MacroPlugin.EXPAND));
            if (editMode) {
                this.expand.setText(Strings.INSTANCE.macroExpand());
                this.expand.setShortcutKeyLabel(Strings.INSTANCE.macroExpandShortcutKeyLabel());
            } else {
                this.expand.setText(Strings.INSTANCE.macroExpandAll());
                this.expand.setShortcutKeyLabel(Strings.INSTANCE.macroExpandAllShortcutKeyLabel());
            }
        }
        if (this.insert.getParentMenu() == event.getSource()) {
            this.insert.setEnabled(!editMode && this.plugin.getTextArea().getCommandManager().isEnabled(MacroPlugin.INSERT));
            this.insert.setVisible(!editMode);
        }
        if (this.edit.getParentMenu() == event.getSource()) {
            this.edit.setEnabled(editMode && this.plugin.getSelector().getMacroCount() == 1);
            this.edit.setVisible(editMode);
        }
    }
}

