/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.style.exec;

import com.google.gwt.dom.client.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.BlockStyleExecutable;

public class BlockStyleNameExecutable
extends BlockStyleExecutable {
    private boolean executed;

    public BlockStyleNameExecutable(RichTextArea rta) {
        super(rta, null);
    }

    public boolean execute(String parameter) {
        this.executed = this.getStyleNames(this.rta.getDocument().getSelection()).contains(parameter);
        return super.execute(parameter);
    }

    protected void execute(Node node, int startOffset, int endOffset, String value) {
        if (this.executed) {
            this.removeStyleName(node, value);
        } else if (!this.matchesStyleName(node, value)) {
            super.execute(node, startOffset, endOffset, value);
        }
    }

    protected void addStyle(Element element, String styleName) {
        element.addClassName(styleName);
    }

    protected void removeStyleName(Node node, String styleName) {
        for (Node ancestor = this.domUtils.getNearestBlockContainer(node); ancestor != null && ancestor.getNodeType() == 1; ancestor = ancestor.getParentNode()) {
            Element.as((Node)ancestor).removeClassName(styleName);
        }
    }

    protected boolean matchesStyleName(Node node, String styleName) {
        for (Node ancestor = this.domUtils.getNearestBlockContainer(node); ancestor != null && ancestor.getNodeType() == 1; ancestor = ancestor.getParentNode()) {
            if (!Element.as((Node)ancestor).hasClassName(styleName)) continue;
            return true;
        }
        return false;
    }

    public String getParameter() {
        return StringUtils.join(this.getStyleNames(this.rta.getDocument().getSelection()), (String)" ");
    }

    protected Set<String> getStyleNames(Selection selection) {
        Set<String> selectionStyleNames = null;
        for (int i = 0; i < selection.getRangeCount(); ++i) {
            Set<String> rangeStyleNames = this.getStyleNames(selection.getRangeAt(i));
            if (selectionStyleNames == null) {
                selectionStyleNames = rangeStyleNames;
            } else {
                selectionStyleNames.retainAll(rangeStyleNames);
            }
            if (selectionStyleNames.isEmpty()) break;
        }
        if (selectionStyleNames == null) {
            selectionStyleNames = Collections.emptySet();
        }
        return selectionStyleNames;
    }

    protected Set<String> getStyleNames(Range range) {
        Node leaf = this.domUtils.getFirstLeaf(range);
        if (leaf == null) {
            return this.getStyleNames(range.getStartContainer());
        }
        Node lastLeaf = this.domUtils.getLastLeaf(range);
        Set<String> rangeStyleNames = this.getStyleNames(leaf);
        while (leaf != lastLeaf && !rangeStyleNames.isEmpty()) {
            leaf = this.domUtils.getNextLeaf(leaf);
            rangeStyleNames.retainAll(this.getStyleNames(leaf));
        }
        return rangeStyleNames;
    }

    protected Set<String> getStyleNames(Node node) {
        HashSet<String> styleNames = new HashSet<String>();
        for (Node ancestor = this.domUtils.getNearestBlockContainer(node); ancestor != null && ancestor.getNodeType() == 1; ancestor = ancestor.getParentNode()) {
            String className = Element.as((Node)ancestor).getClassName();
            if (StringUtils.isEmpty((String)className)) continue;
            styleNames.addAll(Arrays.asList(className.split("\\s+")));
        }
        return styleNames;
    }

    public boolean isExecuted() {
        return true;
    }
}

