/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.justify;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.BlockStyleExecutable;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.ToggleExecutable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

public class JustifyPlugin
extends AbstractStatefulPlugin
implements ClickHandler {
    private final Map<ToggleButton, Command> buttons = new HashMap<ToggleButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.registerCustomExecutable(Command.JUSTIFY_LEFT, "left");
        this.registerCustomExecutable(Command.JUSTIFY_CENTER, "center");
        this.registerCustomExecutable(Command.JUSTIFY_RIGHT, "right");
        this.registerCustomExecutable(Command.JUSTIFY_FULL, "justify");
        this.addFeature("justifyleft", Command.JUSTIFY_LEFT, Images.INSTANCE.justifyLeft(), Strings.INSTANCE.justifyLeft());
        this.addFeature("justifycenter", Command.JUSTIFY_CENTER, Images.INSTANCE.justifyCenter(), Strings.INSTANCE.justifyCenter());
        this.addFeature("justifyright", Command.JUSTIFY_RIGHT, Images.INSTANCE.justifyRight(), Strings.INSTANCE.justifyRight());
        this.addFeature("justifyfull", Command.JUSTIFY_FULL, Images.INSTANCE.justifyFull(), Strings.INSTANCE.justifyFull());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.registerTextAreaHandlers();
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void registerCustomExecutable(Command command, String alignment) {
        this.getTextArea().getCommandManager().registerCommand(command, (Executable)new ToggleExecutable((Executable)new BlockStyleExecutable(this.getTextArea(), Style.TEXT_ALIGN), alignment, Style.TEXT_ALIGN.getDefaultValue()));
    }

    private ToggleButton addFeature(String name, Command command, ImageResource imageResource, String title) {
        ToggleButton button = null;
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            button = new ToggleButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
        return button;
    }

    public void destroy() {
        for (ToggleButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }

    public void update() {
        for (Map.Entry<ToggleButton, Command> entry : this.buttons.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            entry.getKey().setDown(this.getTextArea().getCommandManager().isExecuted(entry.getValue()));
        }
    }
}

