/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.style;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptGroupElement;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.style.StyleDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.style.StyleDescriptorJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.style.exec.BlockStyleNameExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.style.exec.InlineStyleNameExecutable;

public class StylePlugin
extends AbstractStatefulPlugin
implements ChangeHandler {
    private static final Command INLINE_STYLE_NAME = new Command("inlineStyleName");
    private static final Command BLOCK_STYLE_NAME = new Command("blockStyleName");
    private static final String SELECTED = "selected";
    private static final String INLINE = "inline";
    private ListBox styleNamePicker;
    private final List<OptionElement> inlineStyles = new ArrayList<OptionElement>();
    private final List<OptionElement> blockStyles = new ArrayList<OptionElement>();
    private final Map<Command, String> previousValue = new HashMap<Command, String>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(INLINE_STYLE_NAME, (Executable)new InlineStyleNameExecutable(textArea));
        this.getTextArea().getCommandManager().registerCommand(BLOCK_STYLE_NAME, (Executable)new BlockStyleNameExecutable(textArea));
        if (this.getTextArea().getCommandManager().isSupported(INLINE_STYLE_NAME)) {
            this.initStyleNamePicker();
            this.registerTextAreaHandlers();
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void initStyleNamePicker() {
        this.styleNamePicker = new ListBox();
        this.styleNamePicker.setTitle(Strings.INSTANCE.stylePickerTitle());
        this.styleNamePicker.addStyleName("xStyleNamePicker");
        this.styleNamePicker.addItem(Strings.INSTANCE.stylePickerLabel(), "");
        this.saveRegistration(this.styleNamePicker.addChangeHandler((ChangeHandler)this));
        StyleDescriptorJSONParser parser = new StyleDescriptorJSONParser();
        for (StyleDescriptor descriptor : parser.parse(this.getConfig().getParameter("styleNames", "[]"))) {
            this.styleNamePicker.addItem(descriptor.getLabel(), descriptor.getName());
            NodeList options = SelectElement.as((Element)this.styleNamePicker.getElement()).getOptions();
            OptionElement option = (OptionElement)options.getItem(options.getLength() - 1);
            option.setPropertyBoolean(INLINE, descriptor.isInline());
            (descriptor.isInline() ? this.inlineStyles : this.blockStyles).add(option);
        }
        if (this.blockStyles.size() > 0 && this.inlineStyles.size() > 0) {
            this.groupStyleNames(Strings.INSTANCE.styleBlockGroupLabel(), this.blockStyles);
            this.groupStyleNames(Strings.INSTANCE.styleInlineGroupLabel(), this.inlineStyles);
        }
        this.styleNamePicker.setSelectedIndex(0);
        this.toolBarExtension.addFeature("stylename", (UIObject)this.styleNamePicker);
    }

    private void groupStyleNames(String groupLabel, List<OptionElement> styleNames) {
        OptGroupElement group = this.styleNamePicker.getElement().getOwnerDocument().createOptGroupElement();
        group.setLabel(groupLabel);
        this.styleNamePicker.getElement().appendChild((Node)group);
        for (OptionElement styleName : styleNames) {
            group.appendChild((Node)styleName);
        }
    }

    public void destroy() {
        if (this.styleNamePicker != null) {
            this.styleNamePicker.removeFromParent();
            this.styleNamePicker = null;
        }
        this.blockStyles.clear();
        this.inlineStyles.clear();
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onChange(ChangeEvent event) {
        if (this.styleNamePicker == event.getSource() && this.styleNamePicker.isEnabled()) {
            int selectedIndex = this.styleNamePicker.getSelectedIndex();
            this.styleNamePicker.setSelectedIndex(0);
            if (selectedIndex > 0) {
                if (selectedIndex <= this.blockStyles.size()) {
                    this.toggleStyle(this.blockStyles.get(selectedIndex - 1));
                } else {
                    this.toggleStyle(this.inlineStyles.get(selectedIndex - this.blockStyles.size() - 1));
                }
            }
        }
    }

    private void toggleStyle(OptionElement styleOption) {
        String styleName = styleOption.getValue();
        Command command = styleOption.getPropertyBoolean(INLINE) ? INLINE_STYLE_NAME : BLOCK_STYLE_NAME;
        this.getTextArea().setFocus(true);
        this.getTextArea().getCommandManager().execute(command, styleName);
    }

    public void update() {
        if (this.styleNamePicker.isEnabled()) {
            this.update(this.blockStyles, BLOCK_STYLE_NAME);
            this.update(this.inlineStyles, INLINE_STYLE_NAME);
        }
    }

    private void update(List<OptionElement> styleNameOptions, Command styleNameCommand) {
        String previouslyAppliedStyleNames;
        if (styleNameOptions.size() == 0) {
            return;
        }
        String appliedStyleNames = this.getTextArea().getCommandManager().getStringValue(styleNameCommand);
        if (appliedStyleNames.equals(previouslyAppliedStyleNames = this.previousValue.get(styleNameCommand))) {
            return;
        }
        this.previousValue.put(styleNameCommand, appliedStyleNames);
        HashSet<String> styleNames = new HashSet<String>(Arrays.asList(appliedStyleNames.split("\\s+")));
        for (OptionElement option : styleNameOptions) {
            if (styleNames.contains(option.getValue())) {
                option.addClassName(SELECTED);
                continue;
            }
            option.removeClassName(SELECTED);
        }
        this.styleNamePicker.getElement().getStyle().setDisplay(Style.Display.NONE);
        this.styleNamePicker.getElement().getStyle().clearDisplay();
    }
}

