/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.table;

import com.google.gwt.core.client.Scheduler;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TableFeature;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.DeleteCol;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.DeleteRow;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.DeleteTable;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertColAfter;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertColBefore;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertRowAfter;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertRowBefore;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertTable;
import org.xwiki.gwt.wysiwyg.client.plugin.table.ui.TableMenuExtension;

public class TablePlugin
extends AbstractPlugin
implements CommandListener {
    private final List<TableFeature> features = new ArrayList<TableFeature>();
    private TableMenuExtension menuExtension;

    public void init(RichTextArea rta, Config config) {
        super.init(rta, config);
        this.addFeature(rta, new InsertTable(this));
        this.addFeature(rta, new InsertRowBefore(this));
        this.addFeature(rta, new InsertRowAfter(this));
        this.addFeature(rta, new DeleteRow(this));
        this.addFeature(rta, new InsertColBefore(this));
        this.addFeature(rta, new InsertColAfter(this));
        this.addFeature(rta, new DeleteCol(this));
        this.addFeature(rta, new DeleteTable(this));
        this.menuExtension = new TableMenuExtension(this);
        this.getUIExtensionList().add(this.menuExtension);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TablePlugin.this.menuExtension.registerAttachHandlers();
            }
        });
        rta.getCommandManager().addCommandListener((CommandListener)this);
        this.disableInlineTableEditing();
    }

    public void destroy() {
        for (TableFeature feature : this.features) {
            feature.destroy();
        }
        this.features.clear();
        this.menuExtension.clearFeatures();
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
        super.destroy();
    }

    private void addFeature(RichTextArea rta, TableFeature feature) {
        rta.getCommandManager().registerCommand(feature.getCommand(), (Executable)feature);
        this.features.add(feature);
    }

    public List<TableFeature> getFeatures() {
        return this.features;
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if ("enable".equalsIgnoreCase(command.toString())) {
            this.disableInlineTableEditing();
        }
    }

    private void disableInlineTableEditing() {
        if (this.getTextArea().isEnabled()) {
            this.getTextArea().getDocument().execCommand("enableInlineTableEditing", "false");
        }
    }
}

