/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.font;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.InlineStyleExecutable;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.font.FontFamilyPicker;
import org.xwiki.gwt.wysiwyg.client.plugin.font.FontSizePicker;
import org.xwiki.gwt.wysiwyg.client.plugin.font.Picker;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

public class FontPlugin
extends AbstractStatefulPlugin
implements ChangeHandler {
    private static final String DEFAULT_FONT_NAMES = "Andale Mono,Arial,Arial Black,Book Antiqua,Comic Sans MS,Courier New,Georgia,Helvetica,Impact,Symbol,Tahoma,Terminal,Times New Roman,Trebuchet MS,Verdana,Webdings,Wingdings";
    private static final String DEFAULT_FONT_SIZES = "8px 10px 12px 14px 18px 24px 36px";
    private final Map<Picker, Command> pickers = new HashMap<Picker, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(Command.FONT_NAME, (Executable)new InlineStyleExecutable(textArea, Style.FONT_FAMILY));
        this.getTextArea().getCommandManager().registerCommand(Command.FONT_SIZE, (Executable)new InlineStyleExecutable(textArea, Style.FONT_SIZE));
        this.addFeature("fontname", Command.FONT_NAME, new FontFamilyPicker(), Strings.INSTANCE.font(), "fontNames", DEFAULT_FONT_NAMES, "\\s*,\\s*");
        this.addFeature("fontsize", Command.FONT_SIZE, new FontSizePicker(), Strings.INSTANCE.fontSize(), "fontSizes", DEFAULT_FONT_SIZES, "\\s+");
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.registerTextAreaHandlers();
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, Command command, ListBox picker, String title, String parameter, String defaultValues, String separator) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            picker.setTitle(title);
            this.saveRegistration(picker.addChangeHandler((ChangeHandler)this));
            String[] values = this.getConfig().getParameter(parameter, defaultValues).split(separator);
            for (int i = 0; i < values.length; ++i) {
                picker.addItem(values[i]);
            }
            this.toolBarExtension.addFeature(name, (UIObject)picker);
            this.pickers.put((Picker)picker, command);
        }
    }

    public void destroy() {
        for (Picker picker : this.pickers.keySet()) {
            ((Widget)picker).removeFromParent();
        }
        this.pickers.clear();
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onChange(ChangeEvent event) {
        Command command = this.pickers.get(event.getSource());
        if (command != null && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command, ((Picker)event.getSource()).getSelectedValue());
        }
    }

    public void update() {
        for (Map.Entry<Picker, Command> entry : this.pickers.entrySet()) {
            if (!((FocusWidget)entry.getKey()).isEnabled()) continue;
            entry.getKey().setSelectedValue(this.getTextArea().getCommandManager().getStringValue(entry.getValue()));
        }
    }
}

