/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractEntityListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public abstract class AbstractPageListSelectorWizardStep
extends AbstractEntityListSelectorWizardStep<LinkConfig, WikiPage> {
    private final WikiServiceAsync wikiService;

    public AbstractPageListSelectorWizardStep(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
        this.setStepTitle(Strings.INSTANCE.linkSelectWikipageTitle());
        this.display().addStyleName("xPagesSelector");
    }

    @Override
    protected String getSelectHelpLabel() {
        return Strings.INSTANCE.linkSelectWikipageHelpLabel();
    }

    @Override
    protected String getSelectErrorMessage() {
        return Strings.INSTANCE.linkNoPageSelectedError();
    }

    @Override
    protected ListItem<WikiPage> getListItem(WikiPage data) {
        ListItem item = new ListItem();
        item.setData((Object)data);
        String documentReferenceAsString = this.serializeDocumentReference(new WikiPageReference(data.getReference()));
        Label pageName = new Label(Strings.INSTANCE.entityLocatedIn() + " " + documentReferenceAsString);
        pageName.addStyleName("xPagePreviewFullname");
        Label title = new Label(data.getTitle());
        title.addStyleName("xPagePreviewTitle");
        FlowPanel ui = new FlowPanel();
        if (!StringUtils.isEmpty((String)data.getTitle())) {
            ui.add((Widget)title);
        }
        ui.setTitle(data.getTitle());
        ui.add((Widget)pageName);
        ui.addStyleName("xPagePreview");
        item.add((Widget)ui);
        return item;
    }

    protected String serializeDocumentReference(WikiPageReference reference) {
        String separator = " \u00bb ";
        return reference.getWikiName() + separator + reference.getSpaceName() + separator + reference.getPageName();
    }

    @Override
    protected ListItem<WikiPage> getNewOptionListItem() {
        ListItem item = new ListItem();
        item.setData(null);
        Label newOptionPanel = new Label(Strings.INSTANCE.linkNewPageOptionLabel());
        newOptionPanel.addStyleName("xNewPagePreview");
        item.add((Widget)newOptionPanel);
        return item;
    }

    public String getNextStep() {
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() == null) {
            return LinkWizard.LinkWizardStep.WIKI_PAGE_CREATOR.toString();
        }
        return LinkWizard.LinkWizardStep.LINK_CONFIG.toString();
    }

    protected WikiServiceAsync getWikiService() {
        return this.wikiService;
    }
}

