/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.DeferredUpdater;
import org.xwiki.gwt.user.client.HandlerRegistrationCollection;
import org.xwiki.gwt.user.client.Updatable;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDisplayer;

public class MacroSelector
implements Updatable,
MouseUpHandler,
KeyUpHandler,
CommandListener {
    private static final Command RESET = new Command("reset");
    private final MacroDisplayer displayer;
    private final DeferredUpdater updater = new DeferredUpdater((Updatable)this);
    private final List<Element> selectedMacros = new ArrayList<Element>();
    private final HandlerRegistrationCollection registrations = new HandlerRegistrationCollection();

    public MacroSelector(MacroDisplayer displayer) {
        this.displayer = displayer;
        this.registrations.add((Object)displayer.getTextArea().addMouseUpHandler((MouseUpHandler)this));
        this.registrations.add((Object)displayer.getTextArea().addKeyUpHandler((KeyUpHandler)this));
        displayer.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
    }

    public void destroy() {
        this.selectedMacros.clear();
        this.registrations.removeHandlers();
        this.displayer.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
    }

    public void onMouseUp(MouseUpEvent event) {
        if (event.getSource() == this.displayer.getTextArea()) {
            Element macro = this.getMacroContaining((Node)event.getNativeEvent().getEventTarget().cast());
            if (macro != null) {
                this.update();
            } else {
                this.updater.deferUpdate();
            }
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getSource() == this.displayer.getTextArea()) {
            this.updater.deferUpdate();
        }
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        if (RESET.equals((Object)command)) {
            this.selectedMacros.clear();
        }
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if (sender == this.displayer.getTextArea().getCommandManager()) {
            this.updater.deferUpdate();
        }
    }

    public void update() {
        for (Element container : this.selectedMacros) {
            this.displayer.setSelected(container, false);
        }
        this.selectedMacros.clear();
        Selection selection = this.displayer.getTextArea().getDocument().getSelection();
        for (int i = 0; i < selection.getRangeCount(); ++i) {
            Range shrunkenRange = DOMUtils.getInstance().shrinkRange(selection.getRangeAt(i));
            Element macro = this.getMacroContaining(shrunkenRange.getCommonAncestorContainer());
            if (macro == null) continue;
            this.selectedMacros.add(macro);
            this.displayer.setSelected(macro, true);
        }
    }

    public boolean canUpdate() {
        return this.displayer.getTextArea().isAttached() && this.displayer.getTextArea().isEnabled();
    }

    public int getMacroCount() {
        return this.selectedMacros.size();
    }

    public Element getMacro(int index) {
        return this.selectedMacros.get(index);
    }

    public MacroDisplayer getDisplayer() {
        return this.displayer;
    }

    private Element getMacroContaining(Node node) {
        for (Node ancestor = node; ancestor != null; ancestor = ancestor.getParentNode()) {
            if (!this.displayer.isMacroContainer(ancestor)) continue;
            return Element.as((Node)ancestor);
        }
        return null;
    }
}

