/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.readonly;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Node;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Event;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.KeyboardAdaptor;
import org.xwiki.gwt.wysiwyg.client.plugin.readonly.ReadOnlyUtils;

public class ReadOnlyKeyboardHandler
extends KeyboardAdaptor {
    private static final List<Integer> NON_PRINTING_KEY_CODES = Arrays.asList(27, 33, 34, 35, 36, 37, 38, 39, 40);
    private final DOMUtils domUtils = DOMUtils.getInstance();
    private final ReadOnlyUtils readOnlyUtils = new ReadOnlyUtils();

    protected void handleRepeatableKey(Event event) {
        if (event.getKeyCode() == 8 || event.getKeyCode() == 46) {
            this.onDelete(event);
        } else if (!NON_PRINTING_KEY_CODES.contains(event.getKeyCode())) {
            this.onTyping(event);
        }
    }

    private void onDelete(Event event) {
        Document document = (Document)Element.as((JavaScriptObject)event.getEventTarget()).getOwnerDocument().cast();
        this.onDelete(event, document.getSelection().getRangeAt(0));
    }

    private void onDelete(Event event, Range range) {
        if (range.isCollapsed()) {
            Element target = this.readOnlyUtils.getClosestReadOnlyAncestor(range.getCommonAncestorContainer());
            if ((target == null || this.isDeleteAfter(event, target, range) || this.isBackspaceBefore(event, target, range)) && (target = this.getNearbyReadOnlyContainer(range, event.getKeyCode() == 46)) == null) {
                return;
            }
            this.onDelete(event, target);
        } else {
            Element endContainerReadOnlyAncestor;
            Element startContainerReadOnlyAncestor = this.readOnlyUtils.getClosestReadOnlyAncestor(range.getStartContainer());
            Element element = endContainerReadOnlyAncestor = range.getStartContainer() != range.getEndContainer() ? this.readOnlyUtils.getClosestReadOnlyAncestor(range.getEndContainer()) : startContainerReadOnlyAncestor;
            if (startContainerReadOnlyAncestor == endContainerReadOnlyAncestor) {
                if (startContainerReadOnlyAncestor != null) {
                    this.onDelete(event, startContainerReadOnlyAncestor);
                }
            } else {
                this.onDelete(event, startContainerReadOnlyAncestor, range, true);
                this.onDelete(event, endContainerReadOnlyAncestor, range, false);
            }
        }
    }

    private boolean isBackspaceBefore(Event event, Element container, Range caret) {
        return event.getKeyCode() == 8 && this.isBefore(caret, container);
    }

    private boolean isBefore(Range caret, Element container) {
        Node leaf = this.domUtils.getFirstLeaf((Node)container);
        return this.domUtils.comparePoints(caret.getEndContainer(), caret.getEndOffset(), leaf, 0) <= 0;
    }

    private boolean isDeleteAfter(Event event, Element container, Range caret) {
        return event.getKeyCode() == 46 && this.isAfter(caret, container);
    }

    private boolean isAfter(Range caret, Element container) {
        Node leaf = this.domUtils.getLastLeaf((Node)container);
        return this.domUtils.comparePoints(leaf, this.domUtils.getLength(leaf), caret.getStartContainer(), caret.getStartOffset()) <= 0;
    }

    protected void onDelete(Event event, Element element) {
        element.getParentNode().removeChild((Node)element);
        event.xPreventDefault();
    }

    protected void onDelete(Event event, Element element, Range range, boolean start) {
        this.domUtils.detach((Node)element);
    }

    private Element getNearbyReadOnlyContainer(Range caret, boolean right) {
        if (caret.getStartContainer().getNodeType() == 3) {
            boolean atEnd;
            boolean left = !right;
            boolean atStart = caret.getStartOffset() == 0;
            boolean bl = atEnd = caret.getStartOffset() == caret.getStartContainer().getNodeValue().length();
            if (left && !atStart || right && !atEnd) {
                return null;
            }
        }
        Node leaf = right ? this.domUtils.getNextLeaf(caret) : this.domUtils.getPreviousLeaf(caret);
        return leaf != null ? this.readOnlyUtils.getClosestReadOnlyAncestor(leaf) : null;
    }

    private void onTyping(Event event) {
        Document document = (Document)Element.as((JavaScriptObject)event.getEventTarget()).getOwnerDocument().cast();
        Range range = document.getSelection().getRangeAt(0);
        if (this.isBoundary(range)) {
            Element readOnlyContainer = this.readOnlyUtils.getClosestReadOnlyAncestor(range.getStartContainer());
            if (readOnlyContainer != null) {
                int readOnlyBoundary = this.isBoundary(range, readOnlyContainer);
                if (readOnlyBoundary == 0) {
                    event.xPreventDefault();
                } else {
                    this.moveCaretOutside((Node)readOnlyContainer, readOnlyBoundary < 0);
                }
            }
        } else if (this.readOnlyUtils.isRangeBoundaryInsideReadOnlyElement(range)) {
            event.xPreventDefault();
        }
    }

    private boolean isBoundary(Range range) {
        return range.isCollapsed() && (range.getStartContainer().getNodeType() == 1 || range.getStartOffset() == 0 || range.getStartOffset() == range.getStartContainer().getNodeValue().length());
    }

    private int isBoundary(Range caret, Element container) {
        Range betweenNodes = caret;
        if (!this.domUtils.canHaveChildren(caret.getStartContainer())) {
            betweenNodes = caret.cloneRange();
            betweenNodes.selectNode(caret.getStartContainer());
            betweenNodes.collapse(caret.getStartOffset() == 0);
        }
        if (!this.hasVisibleContentBefore((Node)container, betweenNodes)) {
            return -1;
        }
        if (!this.hasVisibleContentAfter((Node)container, betweenNodes)) {
            return 1;
        }
        return 0;
    }

    private boolean hasVisibleContentBefore(Node container, Range caret) {
        Node leaf = this.domUtils.getPreviousLeaf(caret);
        if (leaf == null || !container.isOrHasChild(leaf)) {
            return false;
        }
        Node firstLeaf = this.domUtils.getFirstLeaf(container);
        while (!this.isVisible(leaf)) {
            if (leaf == firstLeaf) {
                return false;
            }
            leaf = this.domUtils.getPreviousLeaf(leaf);
        }
        return true;
    }

    private boolean hasVisibleContentAfter(Node container, Range caret) {
        Node leaf = this.domUtils.getNextLeaf(caret);
        if (leaf == null || !container.isOrHasChild(leaf)) {
            return false;
        }
        Node lastLeaf = this.domUtils.getLastLeaf(container);
        while (!this.isVisible(leaf)) {
            if (leaf == lastLeaf) {
                return false;
            }
            leaf = this.domUtils.getNextLeaf(leaf);
        }
        return true;
    }

    private boolean isVisible(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 1: {
                return "br".equalsIgnoreCase(node.getNodeName()) || Element.as((Node)node).getOffsetWidth() > 0;
            }
            case 3: {
                return node.getNodeValue().length() > 0 && this.isVisible(node.getParentNode());
            }
        }
        return false;
    }

    protected void moveCaretOutside(Node node, boolean before) {
        Document document = (Document)node.getOwnerDocument().cast();
        Range range = document.createRange();
        range.selectNode(node);
        range.collapse(before);
        Selection selection = document.getSelection();
        selection.removeAllRanges();
        selection.addRange(range);
    }
}

