/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.color;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlowPanel;
import org.xwiki.gwt.wysiwyg.client.plugin.color.ColorConverter;

public class ColorCell
extends FlowPanel {
    public static final String NORMAL_STYLE_NAME = "colorCell";
    public static final String SELECTED_DARK_STYLE_NAME = "colorCell-selected-dark";
    public static final String SELECTED_LIGHT_STYLE_NAME = "colorCell-selected-light";
    public static final String HOVERED_STYLE_NAME = "colorCell-hover";
    private final String color;
    private final String hexColorCode;
    private final String selectedStyleName;
    private final ColorConverter converter = new ColorConverter();
    private boolean selected;

    public ColorCell(String color) {
        this.color = color;
        this.hexColorCode = this.converter.convertToHex(color);
        this.selectedStyleName = this.getBrightness(this.hexColorCode) < 0.5 ? SELECTED_DARK_STYLE_NAME : SELECTED_LIGHT_STYLE_NAME;
        this.getElement().getStyle().setBackgroundColor(color);
        this.addStyleName(NORMAL_STYLE_NAME);
        this.sinkEvents(48);
    }

    public String getColor() {
        return this.color;
    }

    public String getHexColorCode() {
        return this.hexColorCode;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.removeStyleName(HOVERED_STYLE_NAME);
            this.addStyleName(this.selectedStyleName);
        } else {
            this.removeStyleName(this.selectedStyleName);
        }
    }

    public void onBrowserEvent(Event event) {
        if (event.getTypeInt() == 16) {
            this.addStyleName(HOVERED_STYLE_NAME);
        } else if (event.getTypeInt() == 32) {
            this.removeStyleName(HOVERED_STYLE_NAME);
        }
        super.onBrowserEvent(event);
    }

    private double getBrightness(String color) {
        if (color == null) {
            return 1.0;
        }
        int red = Integer.parseInt(color.substring(1, 3), 16);
        int green = Integer.parseInt(color.substring(3, 5), 16);
        int blue = Integer.parseInt(color.substring(5, 7), 16);
        return (double)red / 255.0 * 0.3 + (double)green / 255.0 * 0.59 + (double)blue / 255.0 * 0.11;
    }
}

