/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.CurrentPageImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageDispatcherWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImagesExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.URLImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AttachmentSelectorAggregatorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.LinkUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.ResourceReferenceSerializerWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImageWizard
extends Wizard
implements WizardStepProvider {
    private Map<ImageWizardStep, WizardStep> stepsMap = new HashMap<ImageWizardStep, WizardStep>();
    private final Config config;
    private final WikiServiceAsync wikiService;

    public ImageWizard(Config config, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.imageTooltip(), new Image(Images.INSTANCE.image()));
        this.config = config;
        this.wikiService = wikiService;
        this.setProvider(this);
    }

    public WizardStep getStep(String name) {
        ImageWizardStep requestedStep = this.parseStepName(name);
        WizardStep step = this.stepsMap.get((Object)requestedStep);
        if (step == null && (step = this.getStep(requestedStep)) != null) {
            this.stepsMap.put(requestedStep, step);
        }
        return step;
    }

    private WizardStep getStep(ImageWizardStep requestedStep) {
        WizardStep step = null;
        switch (requestedStep) {
            case IMAGE_REFERENCE_PARSER: {
                step = this.createImageDispatcherStep();
                break;
            }
            case ATTACHED_IMAGE_SELECTOR: {
                step = this.createAttachedImageSelectorStep();
                break;
            }
            case URL_IMAGE_SELECTOR: {
                step = this.createURLImageSelectorStep();
                break;
            }
            case IMAGE_UPLOAD: {
                step = this.createImageUploadStep();
                break;
            }
            case IMAGE_CONFIG: {
                step = this.createImageConfigStep();
                break;
            }
            case IMAGE_REFERENCE_SERIALIZER: {
                step = this.createImageReferenceSerializerStep();
                break;
            }
        }
        return step;
    }

    private WizardStep createImageDispatcherStep() {
        boolean allowExternalImages = Boolean.valueOf(this.config.getParameter("allowExternalImages", "true"));
        ImageDispatcherWizardStep imageDispatcher = new ImageDispatcherWizardStep(allowExternalImages, this.wikiService);
        imageDispatcher.setStepTitle(Strings.INSTANCE.imageSelectImageTitle());
        return imageDispatcher;
    }

    private WizardStep createAttachedImageSelectorStep() {
        boolean selectionLimitedToCurrentPage = "currentpage".equals(this.config.getParameter("insertimages"));
        AttachmentSelectorAggregatorWizardStep attachedImageSelector = new AttachmentSelectorAggregatorWizardStep(selectionLimitedToCurrentPage);
        attachedImageSelector.setStepTitle(Strings.INSTANCE.imageSelectImageTitle());
        attachedImageSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.NEXT));
        attachedImageSelector.setCurrentPageSelector((WizardStep)new CurrentPageImageSelectorWizardStep(this.wikiService, false));
        if (!selectionLimitedToCurrentPage) {
            attachedImageSelector.setAllPagesSelector((WizardStep)new ImagesExplorerWizardStep(false, this.wikiService));
        }
        return attachedImageSelector;
    }

    private WizardStep createURLImageSelectorStep() {
        URLImageSelectorWizardStep urlImageSelector = new URLImageSelectorWizardStep();
        urlImageSelector.setNextStep(ImageWizardStep.IMAGE_CONFIG.toString());
        urlImageSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.NEXT, NavigationListener.NavigationDirection.FINISH));
        urlImageSelector.setDirectionName(NavigationListener.NavigationDirection.NEXT, Strings.INSTANCE.imageSettingsLabel());
        urlImageSelector.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.imageCreateImageButton());
        return urlImageSelector;
    }

    private WizardStep createImageConfigStep() {
        ImageConfigWizardStep imageConfigStep = new ImageConfigWizardStep();
        imageConfigStep.setNextStep(ImageWizardStep.IMAGE_REFERENCE_SERIALIZER.toString());
        imageConfigStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.FINISH, NavigationListener.NavigationDirection.PREVIOUS));
        imageConfigStep.setDirectionName(NavigationListener.NavigationDirection.PREVIOUS, Strings.INSTANCE.imageChangeImageButton());
        imageConfigStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.imageCreateImageButton());
        return imageConfigStep;
    }

    private WizardStep createImageUploadStep() {
        LinkUploadWizardStep imageUploadStep = new LinkUploadWizardStep(this.wikiService);
        imageUploadStep.setFileHelpLabel(Strings.INSTANCE.imageUploadHelpLabel());
        imageUploadStep.setNextStep(ImageWizardStep.IMAGE_CONFIG.toString());
        imageUploadStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.NEXT, NavigationListener.NavigationDirection.FINISH));
        imageUploadStep.setDirectionName(NavigationListener.NavigationDirection.NEXT, Strings.INSTANCE.imageSettingsLabel());
        imageUploadStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.imageCreateImageButton());
        return imageUploadStep;
    }

    private WizardStep createImageReferenceSerializerStep() {
        ResourceReferenceSerializerWizardStep imageRefSerializer = new ResourceReferenceSerializerWizardStep(this.wikiService);
        imageRefSerializer.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.FINISH));
        imageRefSerializer.setStepTitle(Strings.INSTANCE.imageConfigTitle());
        return imageRefSerializer;
    }

    public void start(String startStep, Object data) {
        WikiPageReference origin = new WikiPageReference();
        origin.setWikiName(this.config.getParameter("wiki"));
        origin.setSpaceName(this.config.getParameter("space"));
        origin.setPageName(this.config.getParameter("page"));
        ResourceReference destination = new ResourceReference();
        destination.setEntityReference(origin.getEntityReference().clone());
        destination.setType(ResourceReference.ResourceType.ATTACHMENT);
        destination.setTyped(false);
        super.start(startStep, new EntityLink<ImageConfig>(origin.getEntityReference(), destination, (ImageConfig)data));
    }

    protected Object getResult() {
        return ((EntityLink)super.getResult()).getData();
    }

    private ImageWizardStep parseStepName(String name) {
        ImageWizardStep requestedStep = null;
        try {
            requestedStep = ImageWizardStep.valueOf(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return requestedStep;
    }

    public static enum ImageWizardStep {
        IMAGE_REFERENCE_PARSER,
        ATTACHED_IMAGE_SELECTOR,
        URL_IMAGE_SELECTOR,
        IMAGE_UPLOAD,
        IMAGE_CONFIG,
        IMAGE_REFERENCE_SERIALIZER;

    }
}

