/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.AbstractInteractiveWizardStep;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.URIReference;

public class URLImageSelectorWizardStep
extends AbstractInteractiveWizardStep
implements SourcesNavigationEvents,
KeyUpHandler {
    private static final String FIELD_ERROR_STYLE = "xErrorField";
    private static final String PROTOCOL_DELIMITER = "://";
    private EntityLink<ImageConfig> entityLink;
    private final NavigationListenerCollection navigationListeners = new NavigationListenerCollection();
    private final TextBox source = new TextBox();
    private final Label sourceValidationError = new Label(Strings.INSTANCE.imageExternalLocationNotSpecifiedError());

    public URLImageSelectorWizardStep() {
        this.setStepTitle(Strings.INSTANCE.imageSelectImageTitle());
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        FlowPanel sourceLabel = new FlowPanel();
        sourceLabel.setStyleName("xInfoLabel");
        sourceLabel.add((Widget)new InlineLabel(Strings.INSTANCE.imageExternalLocationLabel()));
        sourceLabel.add((Widget)mandatoryLabel);
        this.display().add((Widget)sourceLabel);
        Label sourceHelpLabel = new Label(Strings.INSTANCE.imageExternalLocationHelpLabel());
        sourceHelpLabel.setStyleName("xHelpLabel");
        this.display().add((Widget)sourceHelpLabel);
        this.sourceValidationError.addStyleName("xErrorMsg");
        this.sourceValidationError.setVisible(false);
        this.display().add((Widget)this.sourceValidationError);
        this.source.setTitle(Strings.INSTANCE.imageExternalLocationLabel());
        this.source.addKeyUpHandler((KeyUpHandler)this);
        this.display().add((Widget)this.source);
        this.display().addStyleName("xExternalImage");
    }

    public Object getResult() {
        return this.entityLink;
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.entityLink = (EntityLink)data;
        String imageURL = this.entityLink.getData().getUrl();
        if (!StringUtils.isEmpty((String)imageURL) && imageURL.contains(PROTOCOL_DELIMITER)) {
            this.source.setText(imageURL);
        }
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.source));
        cb.onSuccess(null);
    }

    public void onCancel() {
        this.entityLink = null;
        this.hideValidationErrors();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        if (this.validate()) {
            this.updateResult();
            async.onSuccess((Object)true);
        } else {
            async.onSuccess((Object)false);
        }
    }

    private boolean validate() {
        this.hideValidationErrors();
        if (this.source.getText().trim().length() == 0) {
            this.sourceValidationError.setVisible(true);
            this.source.addStyleName(FIELD_ERROR_STYLE);
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.source));
            return false;
        }
        return true;
    }

    private void updateResult() {
        String imageURL = this.source.getText().trim();
        if (!imageURL.contains(PROTOCOL_DELIMITER)) {
            imageURL = "http://" + imageURL;
        }
        this.entityLink.getDestination().setType(ResourceReference.ResourceType.URL);
        this.entityLink.getDestination().setEntityReference(new URIReference(imageURL).getEntityReference());
        this.entityLink.getData().setReference(null);
        this.entityLink.getData().setUrl(imageURL);
    }

    private void hideValidationErrors() {
        this.sourceValidationError.setVisible(false);
        this.source.removeStyleName(FIELD_ERROR_STYLE);
    }

    public void addNavigationListener(NavigationListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.navigationListeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }
}

