/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.wizard.AbstractInteractiveWizardStep;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.PasteFilter;

public class ImportOfficePasteWizardStep
extends AbstractInteractiveWizardStep
implements LoadHandler {
    private RichTextArea textArea;
    private Object result;
    private CheckBox filterStylesCheckBox;
    private final ImportServiceAsync importService;
    private final PasteFilter pasteFilter = (PasteFilter)GWT.create(PasteFilter.class);

    public ImportOfficePasteWizardStep(ImportServiceAsync importService) {
        this.importService = importService;
        this.setStepTitle(Strings.INSTANCE.importOfficePasteWizardStepTitle());
        this.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.FINISH));
        this.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.importWizardImportButtonCaption());
        FlowPanel infoLabel = new FlowPanel();
        infoLabel.setStyleName("xInfoLabel");
        infoLabel.add((Widget)new InlineLabel(Strings.INSTANCE.importOfficePasteInfoLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        infoLabel.add((Widget)mandatoryLabel);
        this.display().add((Widget)infoLabel);
        Label helpLabel = new Label(Strings.INSTANCE.importOfficePasteHelpLabel());
        helpLabel.setStyleName("xHelpLabel");
        this.display().add((Widget)helpLabel);
        this.textArea = new RichTextArea();
        this.textArea.addStyleName("xImportOfficeContentEditor");
        this.textArea.addLoadHandler((LoadHandler)this);
        this.display().add((Widget)this.textArea);
        this.filterStylesCheckBox = new CheckBox(Strings.INSTANCE.importOfficeContentFilterStylesCheckBoxLabel());
        this.filterStylesCheckBox.setValue(Boolean.valueOf(true));
        this.display().add((Widget)this.filterStylesCheckBox);
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.textArea.setHTML("");
        cb.onSuccess(null);
    }

    public Object getResult() {
        return this.result;
    }

    private void setResult(Object result) {
        this.result = result;
    }

    public void onCancel() {
        this.textArea.setHTML("");
    }

    public void onSubmit(final AsyncCallback<Boolean> async) {
        this.pasteFilter.filter((Document)this.textArea.getDocument());
        String officeHTML = this.textArea.getHTML();
        if (officeHTML.trim().equals("")) {
            async.onSuccess((Object)false);
        } else {
            this.importService.cleanOfficeHTML(officeHTML, "wysiwyg", this.getHTMLCleaningParams(), new AsyncCallback<String>(){

                public void onSuccess(String result) {
                    ImportOfficePasteWizardStep.this.setResult(result);
                    async.onSuccess((Object)true);
                }

                public void onFailure(Throwable thrown) {
                    async.onFailure(thrown);
                }
            });
        }
    }

    protected Map<String, String> getHTMLCleaningParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.filterStylesCheckBox.getValue().booleanValue()) {
            params.put("filterStyles", "strict");
        }
        params.put("namespacesAware", Boolean.toString(false));
        return params;
    }

    public void onLoad(LoadEvent event) {
        if (event.getSource() == this.textArea) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.textArea));
        }
    }
}

