/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.indent;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.indent.exec.IndentExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.indent.exec.OutdentExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

public class IndentPlugin
extends AbstractPlugin
implements ClickHandler {
    private final Map<PushButton, Command> buttons = new HashMap<PushButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(Command.INDENT, (Executable)new IndentExecutable(textArea));
        this.getTextArea().getCommandManager().registerCommand(Command.OUTDENT, (Executable)new OutdentExecutable(textArea));
        this.addFeature("indent", Command.INDENT, Images.INSTANCE.indent(), Strings.INSTANCE.indent());
        this.addFeature("outdent", Command.OUTDENT, Images.INSTANCE.outdent(), Strings.INSTANCE.outdent());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, Command command, ImageResource imageResource, String title) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            PushButton button = new PushButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
    }

    public void destroy() {
        for (PushButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }
}

