/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.UIObject;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.user.client.ui.MenuItem;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.MenuItemUIExtensionAdaptor;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkPluginFactory;

public class LinkMenuExtension
extends MenuItemUIExtensionAdaptor {
    private final List<MenuItem> insertItems;
    private final List<MenuItem> editItems;
    private final LinkPlugin plugin;

    public LinkMenuExtension(final LinkPlugin plugin) {
        super("menu");
        this.plugin = plugin;
        MenuItem webPageLink = this.createMenuItem(Strings.INSTANCE.linkToWebPage(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.EXTERNAL);
            }
        });
        MenuItem emailLink = this.createMenuItem(Strings.INSTANCE.linkToEmail(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.EMAIL);
            }
        });
        MenuItem wikiPageLink = this.createMenuItem(Strings.INSTANCE.linkToWikiPage(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.WIKIPAGE);
            }
        });
        MenuItem attachmentLink = this.createMenuItem(Strings.INSTANCE.linkToAttachment(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkInsert(LinkConfig.LinkType.ATTACHMENT);
            }
        });
        MenuItem editLink = this.createMenuItem(Strings.INSTANCE.linkEdit(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onLinkEdit();
            }
        });
        MenuItem removeLink = this.createMenuItem(Strings.INSTANCE.unlink(), Images.INSTANCE.unlink(), new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onUnlink();
            }
        });
        MenuItem linkMenu = this.createMenuItem(Strings.INSTANCE.link(), Images.INSTANCE.link());
        this.insertItems = Arrays.asList(wikiPageLink, attachmentLink, webPageLink, emailLink);
        this.editItems = Arrays.asList(editLink, removeLink);
        this.addFeature(LinkPluginFactory.getInstance().getPluginName(), (UIObject)linkMenu);
        this.addFeature("linkWikiPage", (UIObject)wikiPageLink);
        this.addFeature("linkAttachment", (UIObject)attachmentLink);
        this.addFeature("linkWebPage", (UIObject)webPageLink);
        this.addFeature("linkEmail", (UIObject)emailLink);
        this.addFeature("linkEdit", (UIObject)editLink);
        this.addFeature("linkRemove", (UIObject)removeLink);
    }

    protected void onAttach(AttachEvent event) {
        boolean editMode = this.plugin.getTextArea().getCommandManager().isEnabled(Command.UNLINK);
        boolean canCreateLink = this.plugin.getTextArea().getCommandManager().isEnabled(Command.CREATE_LINK);
        for (MenuItem item : this.insertItems) {
            if (item.getParentMenu() != event.getSource()) continue;
            item.setEnabled(!editMode && canCreateLink);
            item.setVisible(!editMode);
        }
        for (MenuItem item : this.editItems) {
            if (item.getParentMenu() != event.getSource()) continue;
            item.setEnabled(editMode);
            item.setVisible(editMode);
        }
    }
}

