/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro.exec;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractSelectionExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroSelector;

public class CollapseExecutable
extends AbstractSelectionExecutable {
    private final MacroSelector selector;
    private final boolean collapse;

    public CollapseExecutable(MacroSelector selector, boolean collapse) {
        super(selector.getDisplayer().getTextArea());
        this.selector = selector;
        this.collapse = collapse;
    }

    private List<Element> getMacros() {
        if (this.selector.getMacroCount() > 0) {
            ArrayList<Element> macros = new ArrayList<Element>();
            for (int i = 0; i < this.selector.getMacroCount(); ++i) {
                macros.add(this.selector.getMacro(i));
            }
            return macros;
        }
        Element body = (Element)this.selector.getDisplayer().getTextArea().getDocument().getBody().cast();
        return this.selector.getDisplayer().getMacroContainers(body);
    }

    public boolean execute(String param) {
        for (Element macro : this.getMacros()) {
            this.selector.getDisplayer().setCollapsed(macro, this.collapse);
        }
        return true;
    }

    public boolean isExecuted() {
        for (Element macro : this.getMacros()) {
            if (!this.selector.getDisplayer().hasOutput(macro) || this.selector.getDisplayer().isCollapsed(macro) == this.collapse) continue;
            return false;
        }
        return true;
    }
}

