/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.separator;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xwiki.gwt.user.client.HandlerRegistrationCollection;
import org.xwiki.gwt.wysiwyg.client.plugin.separator.AbstractSeparator;

public class MenuBarSeparator
extends AbstractSeparator
implements AttachEvent.Handler {
    private static final String[] FEATURES = new String[]{"|"};
    private final HandlerRegistrationCollection handlerRegistrations = new HandlerRegistrationCollection();
    private final List<MenuItemSeparator> separators = new ArrayList<MenuItemSeparator>();

    public MenuBarSeparator() {
        super("menu");
    }

    public String[] getFeatures() {
        return FEATURES;
    }

    public UIObject getUIObject(String feature) {
        if (FEATURES[0].equals(feature)) {
            MenuItemSeparator separator = new MenuItemSeparator();
            this.separators.add(separator);
            return separator;
        }
        return null;
    }

    public void registerAttachHandlers() {
        this.handlerRegistrations.removeHandlers();
        HashSet<MenuBar> menus = new HashSet<MenuBar>();
        for (MenuItemSeparator separator : this.separators) {
            if (separator.getParentMenu() == null) continue;
            menus.add(separator.getParentMenu());
        }
        for (MenuBar menu : menus) {
            menu.addAttachHandler((AttachEvent.Handler)this);
        }
    }

    public void onAttachOrDetach(AttachEvent event) {
        if (event.isAttached()) {
            final MenuBar menu = (MenuBar)event.getSource();
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    MenuBarSeparator.this.updateSeparators(menu);
                }
            });
        }
    }

    private void updateSeparators(MenuBar menuBar) {
        boolean visible = false;
        MenuItemSeparator lastVisibleSeparator = null;
        for (UIObject item : this.getAllItems(menuBar)) {
            if (item instanceof MenuItemSeparator) {
                MenuItemSeparator separator = (MenuItemSeparator)item;
                separator.setVisible(visible);
                if (visible) {
                    lastVisibleSeparator = separator;
                }
                visible = false;
                continue;
            }
            visible = visible || ((MenuItem)item).isVisible();
        }
        if (lastVisibleSeparator != null) {
            lastVisibleSeparator.setVisible(visible);
        }
    }

    private native List<UIObject> getAllItems(MenuBar var1);

    public void destroy() {
        this.handlerRegistrations.removeHandlers();
        this.separators.clear();
    }
}

