/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.table.util;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;

public final class TableUtils {
    public static final String BODY_NODENAME = "BODY";
    public static final String TABLE_NODENAME = "TABLE";
    public static final String TBODY_NODENAME = "TBODY";
    public static final String ROW_NODENAME = "TR";
    public static final String COL_NODENAME = "TD";
    public static final String COL_HNODENAME = "TH";
    public static final String CELL_DEFAULTHTML = "&nbsp;";
    private static TableUtils instance;

    public static synchronized TableUtils getInstance() {
        if (instance == null) {
            instance = new TableUtils();
        }
        return instance;
    }

    public Range getRange(Document doc) {
        return doc.getSelection().getRangeAt(0);
    }

    public Node getCaretNode(Document doc) {
        return this.getRange(doc).getCommonAncestorContainer();
    }

    public void putCaretInNode(RichTextArea rta, Node node) {
        Selection selection = rta.getDocument().getSelection();
        Range range = rta.getDocument().createRange();
        range.selectNodeContents(node);
        range.collapse(false);
        selection.removeAllRanges();
        selection.addRange(range);
    }

    public TableElement getTable(Node node) {
        return (TableElement)DOMUtils.getInstance().getFirstAncestor(node, new String[]{TABLE_NODENAME});
    }

    public TableRowElement getRow(Node node) {
        return (TableRowElement)DOMUtils.getInstance().getFirstAncestor(node, new String[]{ROW_NODENAME});
    }

    public boolean isHeaderRow(TableRowElement row) {
        return row.getCells().getLength() > 0 && COL_HNODENAME.equalsIgnoreCase(((TableCellElement)row.getCells().getItem(0)).getNodeName());
    }

    public TableCellElement getCell(Node node) {
        TableCellElement cell = (TableCellElement)DOMUtils.getInstance().getFirstAncestor(node, new String[]{COL_NODENAME});
        if (cell == null) {
            cell = (TableCellElement)DOMUtils.getInstance().getFirstAncestor(node, new String[]{COL_HNODENAME});
        }
        return cell;
    }

    public TableCellElement getNextCellInRow(TableCellElement cell) {
        TableRowElement row = this.getRow((Node)cell);
        NodeList cells = row.getCells();
        if (cells.getLength() > cell.getCellIndex() + 1) {
            return (TableCellElement)cells.getItem(cell.getCellIndex() + 1);
        }
        return null;
    }

    public TableCellElement getPreviousCellInRow(TableCellElement cell) {
        TableRowElement row = this.getRow((Node)cell);
        NodeList cells = row.getCells();
        if (cell.getCellIndex() > 0) {
            return (TableCellElement)cells.getItem(cell.getCellIndex() - 1);
        }
        return null;
    }

    public TableCellElement getNextCellInColumn(TableCellElement cell) {
        TableRowElement row = this.getRow((Node)cell);
        TableElement table = this.getTable((Node)row);
        NodeList rows = table.getRows();
        if (rows.getLength() > row.getRowIndex() + 1) {
            return (TableCellElement)((TableRowElement)rows.getItem(row.getRowIndex() + 1)).getCells().getItem(cell.getCellIndex());
        }
        return null;
    }

    public TableCellElement getPreviousCellInColumn(TableCellElement cell) {
        TableRowElement row = this.getRow((Node)cell);
        TableElement table = this.getTable((Node)row);
        NodeList rows = table.getRows();
        if (row.getRowIndex() > 0) {
            return (TableCellElement)((TableRowElement)rows.getItem(row.getRowIndex() - 1)).getCells().getItem(cell.getCellIndex());
        }
        return null;
    }

    public TableRowElement insertRow(Document doc, boolean insertBefore) {
        TableRowElement row = this.getRow(this.getCaretNode(doc));
        TableElement table = this.getTable((Node)row);
        int index = row.getRowIndex();
        if (!insertBefore) {
            ++index;
        }
        TableRowElement newRow = table.insertRow(index);
        int cellCount = row.getCells().getLength();
        for (int i = 0; i < cellCount; ++i) {
            TableCellElement cell = newRow.insertCell(i);
            cell.setInnerHTML(CELL_DEFAULTHTML);
        }
        return newRow;
    }

    public void insertCol(Document doc, boolean insertBefore) {
        TableCellElement cell = this.getCell(this.getCaretNode(doc));
        TableElement table = this.getTable((Node)cell);
        NodeList rows = table.getRows();
        int index = cell.getCellIndex();
        for (int i = 0; i < rows.getLength(); ++i) {
            TableCellElement newCell;
            TableRowElement currentRow = (TableRowElement)rows.getItem(i);
            if (this.isHeaderRow(currentRow)) {
                newCell = doc.createTHElement();
                if (insertBefore) {
                    currentRow.insertBefore((Node)newCell, currentRow.getCells().getItem(index));
                } else {
                    DOMUtils.getInstance().insertAfter((Node)newCell, currentRow.getCells().getItem(index));
                }
            } else {
                newCell = currentRow.insertCell(insertBefore ? index : index + 1);
            }
            newCell.setInnerHTML(CELL_DEFAULTHTML);
        }
    }
}

