/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.ActionHandler;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.NativeActionHandler;
import org.xwiki.gwt.user.client.NativeAsyncCallback;
import org.xwiki.gwt.user.client.internal.DefaultConfig;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManagerApi;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditor;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorDebugger;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorFactory;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverterAsync;

public class WysiwygEditorApi {
    public static final Command SUBMIT = new Command("submit");
    private static final String START_CONTAINER = "startContainer";
    private static final String START_OFFSET = "startOffset";
    private static final String END_CONTAINER = "endContainer";
    private static final String END_OFFSET = "endOffset";
    private WysiwygEditor editor;
    private CommandManagerApi commandManagerApi;
    private final HTMLConverterAsync converter = (HTMLConverterAsync)GWT.create(HTMLConverter.class);

    public WysiwygEditorApi(org.xwiki.gwt.dom.client.JavaScriptObject jsConfig) {
        if (!WysiwygEditorApi.isRichTextEditingSupported()) {
            return;
        }
        DefaultConfig config = new DefaultConfig(jsConfig);
        com.google.gwt.user.client.Element hook = DOM.getElementById((String)config.getParameter("hookId"));
        if (hook == null) {
            return;
        }
        com.google.gwt.user.client.Element container = DOM.createDiv();
        String containerId = hook.getId() + "_container" + Math.round(Math.random() * 1000.0);
        container.setId(containerId);
        hook.getParentElement().insertBefore((Node)container, (Node)hook);
        this.editor = WysiwygEditorFactory.getInstance().newEditor((Config)config);
        if (this.editor.getConfig().isDebugMode()) {
            RootPanel.get((String)containerId).add((Widget)new WysiwygEditorDebugger(this.editor));
        } else {
            RootPanel.get((String)containerId).add(this.editor.getUI());
        }
        Window.addCloseHandler((CloseHandler)new CloseHandler<Window>((Element)container){
            final /* synthetic */ Element val$container;
            {
                this.val$container = element;
            }

            public void onClose(CloseEvent<Window> event) {
                if (WysiwygEditorApi.this.editor != null) {
                    WysiwygEditorApi.this.editor.destroy();
                }
                if (this.val$container.getParentNode() != null) {
                    this.val$container.getParentNode().removeChild((Node)this.val$container);
                }
            }
        });
    }

    public static boolean isRichTextEditingSupported() {
        RichTextArea textArea = new RichTextArea(null);
        return textArea.getFormatter() != null;
    }

    public void release() {
        if (this.editor != null) {
            Widget container = this.editor.getUI();
            while (container.getParent() != null) {
                container = container.getParent();
            }
            RootPanel.detachNow((Widget)container);
            this.editor = null;
        }
    }

    public Element getPlainTextArea() {
        return this.editor == null || !this.editor.getConfig().isTabbed() ? null : this.editor.getPlainTextEditor().getTextArea().getElement();
    }

    public Element getRichTextArea() {
        return this.editor == null ? null : this.editor.getRichTextEditor().getTextArea().getElement();
    }

    public void getSourceText(org.xwiki.gwt.dom.client.JavaScriptObject onSuccess, org.xwiki.gwt.dom.client.JavaScriptObject onFailure) {
        NativeAsyncCallback callback = new NativeAsyncCallback(onSuccess, onFailure);
        if (this.editor.getRichTextEditor().getTextArea().isEnabled()) {
            this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(SUBMIT);
            this.converter.fromHTML(this.editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT), this.editor.getConfig().getSyntax(), (AsyncCallback<String>)callback);
        } else {
            callback.onSuccess((Object)this.editor.getPlainTextEditor().getTextArea().getText());
        }
    }

    public CommandManagerApi getCommandManagerApi() {
        if (this.commandManagerApi == null) {
            this.commandManagerApi = CommandManagerApi.newInstance((CommandManager)this.editor.getRichTextEditor().getTextArea().getCommandManager());
        }
        return this.commandManagerApi;
    }

    public HandlerRegistration addActionHandler(String actionName, org.xwiki.gwt.dom.client.JavaScriptObject jsHandler) {
        if (this.editor != null) {
            return this.editor.getRichTextEditor().getTextArea().addActionHandler(actionName, (ActionHandler)new NativeActionHandler((JavaScriptObject)jsHandler));
        }
        return null;
    }

    public String getParameter(String name) {
        return this.editor.getConfigurationSource().getParameter(name);
    }

    public JsArrayString getParameterNames() {
        JsArrayString parameterNames = (JsArrayString)org.xwiki.gwt.dom.client.JavaScriptObject.createArray().cast();
        for (String parameterName : this.editor.getConfigurationSource().getParameterNames()) {
            parameterNames.push(parameterName);
        }
        return parameterNames;
    }

    public void setFocus(boolean focused) {
        if (this.editor.getRichTextEditor().getTextArea().isEnabled()) {
            this.editor.getRichTextEditor().getTextArea().setFocus(focused);
        } else {
            this.editor.getPlainTextEditor().getTextArea().setFocus(focused);
        }
    }

    public org.xwiki.gwt.dom.client.JavaScriptObject getSelectionRange() {
        Selection selection;
        RichTextArea textArea = this.editor.getRichTextEditor().getTextArea();
        if (textArea.isAttached() && (selection = textArea.getDocument().getSelection()).getRangeCount() > 0) {
            Range range = selection.getRangeAt(0);
            org.xwiki.gwt.dom.client.JavaScriptObject jsRange = (org.xwiki.gwt.dom.client.JavaScriptObject)org.xwiki.gwt.dom.client.JavaScriptObject.createObject();
            jsRange.set(START_CONTAINER, (Object)range.getStartContainer());
            jsRange.set(START_OFFSET, (Object)range.getStartOffset());
            jsRange.set(END_CONTAINER, (Object)range.getEndContainer());
            jsRange.set(END_OFFSET, (Object)range.getEndOffset());
            return jsRange;
        }
        return null;
    }

    public void setSelectionRange(org.xwiki.gwt.dom.client.JavaScriptObject jsRange) {
        RichTextArea textArea = this.editor.getRichTextEditor().getTextArea();
        if (jsRange != null && textArea.isAttached()) {
            Selection selection = textArea.getDocument().getSelection();
            Range range = textArea.getDocument().createRange();
            range.setStart((Node)jsRange.get(START_CONTAINER), ((Integer)jsRange.get(START_OFFSET)).intValue());
            range.setEnd((Node)jsRange.get(END_CONTAINER), ((Integer)jsRange.get(END_OFFSET)).intValue());
            selection.removeAllRanges();
            selection.addRange(range);
        }
    }

    public static native void publish();
}

