/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.PasteManager;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ui.ImportWizard;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImportPlugin
extends AbstractPlugin
implements WizardListener,
ClickHandler {
    private Wizard importWizard;
    private ImportMenuExtension importMenuExtension;
    private final ImportServiceAsync importService;
    private final WikiServiceAsync wikiService;
    private final Map<PushButton, ImportWizard.ImportWizardStep> wizardSteps = new HashMap<PushButton, ImportWizard.ImportWizardStep>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public ImportPlugin(ImportServiceAsync importService, WikiServiceAsync wikiService) {
        this.importService = importService;
        this.wikiService = wikiService;
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        if (Boolean.valueOf(config.getParameter("cleanPaste", "true")).booleanValue()) {
            PasteManager pasteManager = (PasteManager)GWT.create(PasteManager.class);
            this.saveRegistrations(pasteManager.initialize(textArea, this.importService));
        }
        this.importMenuExtension = new ImportMenuExtension(this);
        this.getUIExtensionList().add(this.importMenuExtension);
        this.addFeature("import:officefile", ImportWizard.ImportWizardStep.OFFICE_FILE, Images.INSTANCE.importOfficeFileMenuEntryIcon(), Strings.INSTANCE.importOfficeFileMenuItemCaption());
        this.addFeature("paste", ImportWizard.ImportWizardStep.OFFICE_PASTE, Images.INSTANCE.paste(), Strings.INSTANCE.paste());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, ImportWizard.ImportWizardStep wizardStep, ImageResource imageResource, String title) {
        if (this.getTextArea().getCommandManager().isSupported(Command.INSERT_HTML)) {
            PushButton button = new PushButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.wizardSteps.put(button, wizardStep);
        }
    }

    public void onImportOfficeFile() {
        this.getImportWizard().start(ImportWizard.ImportWizardStep.OFFICE_FILE.toString(), null);
    }

    public void onCancel(Wizard sender) {
        this.getTextArea().setFocus(true);
    }

    public void onFinish(Wizard sender, Object result) {
        this.getTextArea().setFocus(true);
        this.getTextArea().getCommandManager().execute(Command.INSERT_HTML, result.toString());
    }

    public void destroy() {
        for (PushButton button : this.wizardSteps.keySet()) {
            button.removeFromParent();
        }
        this.wizardSteps.clear();
        this.toolBarExtension.clearFeatures();
        this.importMenuExtension.clearFeatures();
        super.destroy();
    }

    private Wizard getImportWizard() {
        if (null == this.importWizard) {
            this.importWizard = new ImportWizard(this.getConfig(), this.importService, this.wikiService);
            this.importWizard.addWizardListener((WizardListener)this);
        }
        return this.importWizard;
    }

    public void onClick(ClickEvent event) {
        Widget sender = (Widget)event.getSource();
        ImportWizard.ImportWizardStep wizardStep = this.wizardSteps.get(sender);
        if (wizardStep != null) {
            this.getImportWizard().start(wizardStep.toString(), null);
        }
    }
}

