/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xwiki.gwt.dom.client.CopyEvent;
import org.xwiki.gwt.dom.client.CopyHandler;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.PasteEvent;
import org.xwiki.gwt.dom.client.PasteHandler;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.ui.LoadingPanel;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.SelectionPreserver;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.PasteFilter;

public class PasteManager
implements PasteHandler,
CopyHandler {
    private static final String DEFAULT_CONTENT_KEY = "__defaultContent";
    private final PasteFilter pasteFilter = (PasteFilter)GWT.create(PasteFilter.class);
    private final LoadingPanel waiting = new LoadingPanel();
    private RichTextArea textArea;
    private ImportServiceAsync importService;
    private SelectionPreserver selectionPreserver;
    private String copyContent;

    public List<HandlerRegistration> initialize(RichTextArea textArea, ImportServiceAsync importService) {
        this.textArea = textArea;
        this.importService = importService;
        this.selectionPreserver = new SelectionPreserver(textArea);
        return this.addHandlers();
    }

    protected List<HandlerRegistration> addHandlers() {
        ArrayList<HandlerRegistration> registrations = new ArrayList<HandlerRegistration>();
        registrations.add(this.textArea.addCopyHandler((CopyHandler)this));
        registrations.add(this.textArea.addPasteHandler((PasteHandler)this));
        return registrations;
    }

    public void onPaste(PasteEvent event) {
        if (this.selectionPreserver.hasSelection()) {
            return;
        }
        this.selectionPreserver.saveSelection();
        final org.xwiki.gwt.dom.client.Element pasteContainer = this.createPasteContainer();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                PasteManager.this.onAfterPaste(pasteContainer);
            }
        });
    }

    private org.xwiki.gwt.dom.client.Element createPasteContainer() {
        Document document = this.textArea.getDocument();
        org.xwiki.gwt.dom.client.Element pasteContainer = org.xwiki.gwt.dom.client.Element.as((Node)document.createDivElement());
        pasteContainer.getStyle().setPosition(Style.Position.ABSOLUTE);
        this.centerPasteContainer(pasteContainer);
        pasteContainer.getStyle().setWidth(1.0, Style.Unit.PX);
        pasteContainer.getStyle().setHeight(1.0, Style.Unit.PX);
        pasteContainer.getStyle().setOverflow(Style.Overflow.HIDDEN);
        pasteContainer.appendChild((Node)document.createTextNode("\u00a0"));
        pasteContainer.setPropertyObject(DEFAULT_CONTENT_KEY, (Object)pasteContainer.getFirstChild());
        document.getBody().appendChild((Node)pasteContainer);
        this.selectPasteContainer(pasteContainer);
        return pasteContainer;
    }

    protected void selectPasteContainer(org.xwiki.gwt.dom.client.Element pasteContainer) {
        this.textArea.getDocument().getSelection().selectAllChildren(pasteContainer.getFirstChild());
    }

    protected void centerPasteContainer(org.xwiki.gwt.dom.client.Element pasteContainer) {
        Document document = this.textArea.getDocument();
        pasteContainer.getStyle().setLeft((double)(document.getScrollLeft() + document.getClientWidth() / 2), Style.Unit.PX);
        pasteContainer.getStyle().setTop((double)(document.getScrollTop() + document.getClientHeight() / 2), Style.Unit.PX);
    }

    private void onAfterPaste(org.xwiki.gwt.dom.client.Element pasteContainer) {
        String pasteContent = "";
        if (this.hasContentBeenPastedIn(pasteContainer)) {
            this.pasteFilter.filter((Element)pasteContainer);
            pasteContent = pasteContainer.xGetInnerHTML();
        }
        pasteContainer.removeProperty(DEFAULT_CONTENT_KEY);
        pasteContainer.removeFromParent();
        this.selectionPreserver.restoreSelection();
        if (this.requiresCleaning(pasteContent)) {
            this.cleanPasteContent(pasteContent);
        } else if (pasteContent.length() > 0) {
            this.paste(pasteContent);
        }
    }

    private boolean hasContentBeenPastedIn(org.xwiki.gwt.dom.client.Element pasteContainer) {
        return pasteContainer.getChildCount() != 1 || pasteContainer.getPropertyObject(DEFAULT_CONTENT_KEY) != pasteContainer.getFirstChild();
    }

    public void onCopy(CopyEvent event) {
        Selection selection = this.textArea.getDocument().getSelection();
        this.copyContent = selection.isCollapsed() || selection.getRangeCount() != 1 ? null : selection.getRangeAt(0).toHTML();
    }

    private boolean requiresCleaning(String pasteContent) {
        return pasteContent.length() > 0 && !pasteContent.equals(this.copyContent) && (pasteContent.indexOf(60) >= 0 || pasteContent.indexOf(62) >= 0);
    }

    private void cleanPasteContent(final String pasteContent) {
        this.waiting.startLoading((Widget)this.textArea);
        this.waiting.setFocus(true);
        HashMap<String, String> cleaningParameters = new HashMap<String, String>();
        cleaningParameters.put("filterStyles", "strict");
        cleaningParameters.put("namespacesAware", Boolean.toString(false));
        this.importService.cleanOfficeHTML(pasteContent, "wysiwyg", cleaningParameters, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                this.onSuccess(pasteContent);
            }

            public void onSuccess(String result) {
                PasteManager.this.waiting.stopLoading();
                PasteManager.this.textArea.setFocus(true);
                PasteManager.this.paste(result);
            }
        });
    }

    private void paste(String content) {
        this.textArea.getCommandManager().execute(Command.INSERT_HTML, content);
        this.textArea.getDocument().getSelection().collapseToEnd();
    }

    protected RichTextArea getTextArea() {
        return this.textArea;
    }
}

