/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.AbstractInteractiveWizardStep;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;

public class CreateNewPageWizardStep
extends AbstractInteractiveWizardStep
implements KeyPressHandler,
SourcesNavigationEvents {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private final TextBox pageNameTextBox = new TextBox();
    private final Label pageNameErrorLabel = new Label();
    private EntityLink<LinkConfig> entityLink;
    private final NavigationListenerCollection listeners = new NavigationListenerCollection();

    public CreateNewPageWizardStep() {
        this.setStepTitle(Strings.INSTANCE.linkCreateNewPageTitle());
        FlowPanel pageNameLabel = new FlowPanel();
        pageNameLabel.setStyleName("xInfoLabel");
        pageNameLabel.add((Widget)new InlineLabel(Strings.INSTANCE.linkNewPageLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        pageNameLabel.add((Widget)mandatoryLabel);
        Label helpPageNameLabel = new Label(Strings.INSTANCE.linkNewPageTextBoxTooltip());
        helpPageNameLabel.setStyleName("xHelpLabel");
        this.pageNameErrorLabel.addStyleName("xErrorMsg");
        this.pageNameErrorLabel.setVisible(false);
        this.display().addStyleName("xLinkToNewPage");
        this.display().add((Widget)pageNameLabel);
        this.display().add((Widget)helpPageNameLabel);
        this.display().add((Widget)this.pageNameErrorLabel);
        this.pageNameTextBox.setTitle(Strings.INSTANCE.linkNewPageTextBoxTooltip());
        this.pageNameTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.display().add((Widget)this.pageNameTextBox);
    }

    public Object getResult() {
        return this.entityLink;
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.entityLink = (EntityLink)data;
        this.hideError();
        cb.onSuccess(null);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.pageNameTextBox));
    }

    public void onCancel() {
    }

    public void onSubmit(AsyncCallback<Boolean> callback) {
        this.hideError();
        String newPageName = this.pageNameTextBox.getText().trim();
        if (StringUtils.isEmpty((String)newPageName)) {
            this.displayError(Strings.INSTANCE.linkNewPageError());
            callback.onSuccess((Object)false);
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.pageNameTextBox));
        } else {
            new WikiPageReference(this.entityLink.getDestination().getEntityReference()).setPageName(newPageName);
            this.entityLink.getData().setReference(null);
            this.entityLink.getData().setUrl(null);
            callback.onSuccess((Object)true);
        }
    }

    private void displayError(String errorMessage) {
        this.pageNameErrorLabel.setText(errorMessage);
        this.pageNameErrorLabel.setVisible(true);
        this.pageNameTextBox.addStyleName(FIELD_ERROR_STYLE);
    }

    private void hideError() {
        this.pageNameErrorLabel.setVisible(false);
        this.pageNameTextBox.removeStyleName(FIELD_ERROR_STYLE);
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getNativeEvent().getKeyCode() == 13) {
            this.listeners.fireNavigationEvent(this.getDefaultDirection());
        }
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public NavigationListener.NavigationDirection getDefaultDirection() {
        return NavigationListener.NavigationDirection.NEXT;
    }
}

