/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.sync;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncResult;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncService;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.wysiwyg.server.plugin.sync.SyncEngine;

public class XWikiSyncService
implements SyncService {
    private static final Log LOG = LogFactory.getLog(XWikiSyncService.class);
    @Requirement
    private SyncEngine syncEngine;
    @Requirement
    private DocumentAccessBridge docAccessBridge;
    @Requirement
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Requirement
    private HTMLConverter htmlConverter;

    public synchronized SyncResult syncEditorContent(Revision revision, String pageName, int version, boolean syncReset) {
        try {
            SyncStatus syncStatus = this.syncEngine.getSyncStatus(pageName);
            if (syncStatus == null || syncReset) {
                DocumentReference docRef = this.documentReferenceResolver.resolve((Object)pageName, new Object[0]);
                DocumentModelBridge docModelBridge = this.docAccessBridge.getDocument(docRef);
                syncStatus = new SyncStatus(pageName, docModelBridge.getVersion(), this.getRenderedContent(docModelBridge));
                this.syncEngine.setSyncStatus(pageName, syncStatus);
            }
            return this.syncEngine.sync(syncStatus, revision, version);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while synchronizing edited content.", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRenderedContent(DocumentModelBridge docModelBridge) throws Exception {
        HashMap backupObjects = new HashMap();
        try {
            this.docAccessBridge.pushDocumentInContext(backupObjects, docModelBridge.getDocumentReference());
            String string = this.htmlConverter.toHTML(docModelBridge.getContent(), docModelBridge.getSyntaxId());
            return string;
        }
        finally {
            this.docAccessBridge.popDocumentFromContext(backupObjects);
        }
    }
}

