/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.filter;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.context.Execution;

public class XWikiContextInitializationFilter
implements Filter {
    private FilterConfig filterConfig;
    private int mode;

    public void destroy() {
        this.filterConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                this.initializeXWikiContext(request, response);
            }
            chain.doFilter(request, response);
        }
        finally {
            if (request instanceof HttpServletRequest) {
                this.cleanupComponents();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        try {
            this.mode = Integer.parseInt(filterConfig.getInitParameter("mode"));
        }
        catch (Exception e) {
            this.mode = -1;
        }
    }

    protected void initializeXWikiContext(ServletRequest request, ServletResponse response) throws ServletException {
        try {
            String action = "";
            XWikiServletContext xwikiEngine = new XWikiServletContext(this.filterConfig.getServletContext());
            XWikiServletRequest xwikiRequest = new XWikiServletRequest((HttpServletRequest)request);
            XWikiServletResponse xwikiResponse = new XWikiServletResponse((HttpServletResponse)response);
            XWikiContext context = Utils.prepareContext((String)action, (XWikiRequest)xwikiRequest, (XWikiResponse)xwikiResponse, (XWikiEngineContext)xwikiEngine);
            if (this.mode >= 0) {
                context.setMode(this.mode);
            }
            this.initializeContainerComponent(context);
            XWiki xwiki = XWiki.getXWiki((XWikiContext)context);
            context.setURLFactory(xwiki.getURLFactoryService().createURLFactory(context.getMode(), context));
            xwiki.prepareResources(context);
            XWikiUser user = context.getWiki().checkAuth(context);
            if (user != null) {
                context.setUser(user.getUser());
            }
        }
        catch (XWikiException e) {
            throw new ServletException("Failed to initialize the XWiki context.", (Throwable)e);
        }
    }

    protected void initializeContainerComponent(XWikiContext context) throws ServletException {
        ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent(ServletContainerInitializer.class);
        try {
            containerInitializer.initializeRequest(context.getRequest().getHttpServletRequest(), (Object)context);
            containerInitializer.initializeResponse(context.getResponse().getHttpServletResponse());
            containerInitializer.initializeSession(context.getRequest().getHttpServletRequest());
        }
        catch (ServletContainerException e) {
            throw new ServletException("Failed to initialize Request/Response or Session", (Throwable)e);
        }
    }

    protected void cleanupComponents() {
        Container container = (Container)Utils.getComponent(Container.class);
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        Execution execution = (Execution)Utils.getComponent(Execution.class);
        execution.removeContext();
    }
}

