/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wysiwyg.server.WysiwygEditorConfiguration;

@Component
@Singleton
public class DefaultWysiwygEditorConfiguration
implements WysiwygEditorConfiguration {
    private static final Integer ONE = new Integer(1);
    private static final String XWIKI_SPACE = "XWiki";
    private static final String EDITOR_CONFIG_DOC = "WysiwygEditorConfig";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelContext modelContext;
    @Inject
    private Execution execution;

    private Object getProperty(String propertyName) {
        String mainWiki;
        DocumentReference configClassReference;
        String currentWiki = this.modelContext.getCurrentEntityReference().getName();
        DocumentReference configDocumentReference = new DocumentReference(currentWiki, XWIKI_SPACE, EDITOR_CONFIG_DOC);
        Object value = this.documentAccessBridge.getProperty(configDocumentReference, configClassReference = new DocumentReference("WysiwygEditorConfigClass", configDocumentReference.getLastSpaceReference()), propertyName);
        if (value == null && !StringUtils.equals((CharSequence)currentWiki, (CharSequence)(mainWiki = this.getMainWiki()))) {
            configDocumentReference = new DocumentReference(mainWiki, XWIKI_SPACE, EDITOR_CONFIG_DOC);
            value = this.documentAccessBridge.getProperty(configDocumentReference, configClassReference, propertyName);
        }
        return value;
    }

    private String getMainWiki() {
        return ((XWikiContext)this.execution.getContext().getProperty("xwikicontext")).getMainXWiki();
    }

    @Override
    public Boolean areExternalImagesAllowed() {
        Integer externalImages = (Integer)this.getProperty("externalImages");
        return externalImages == null ? null : Boolean.valueOf(ONE.equals(externalImages));
    }

    @Override
    public String getColorPalette() {
        return (String)this.getProperty("colorPalette");
    }

    @Override
    public Integer getColorsPerRow() {
        return (Integer)this.getProperty("colorsPerRow");
    }

    @Override
    public String getFontNames() {
        return (String)this.getProperty("fontNames");
    }

    @Override
    public String getFontSizes() {
        return (String)this.getProperty("fontSizes");
    }

    @Override
    public String getMenuBar() {
        return (String)this.getProperty("menuBar");
    }

    @Override
    public String getPlugins() {
        return (String)this.getProperty("plugins");
    }

    @Override
    public String getStyleNames() {
        return (String)this.getProperty("styleNames");
    }

    @Override
    public String getToolBar() {
        return (String)this.getProperty("toolBar");
    }

    @Override
    public Boolean isAttachmentSelectionLimited() {
        Integer attachmentSelectionLimited = (Integer)this.getProperty("attachmentSelectionLimited");
        return attachmentSelectionLimited == null ? null : Boolean.valueOf(ONE.equals(attachmentSelectionLimited));
    }

    @Override
    public Boolean isImageSelectionLimited() {
        Integer imageSelectionLimited = (Integer)this.getProperty("imageSelectionLimited");
        return imageSelectionLimited == null ? null : Boolean.valueOf(ONE.equals(imageSelectionLimited));
    }

    @Override
    public Boolean isSourceEditorEnabled() {
        Integer sourceEditorEnabled = (Integer)this.getProperty("sourceEditorEnabled");
        return sourceEditorEnabled == null ? null : Boolean.valueOf(ONE.equals(sourceEditorEnabled));
    }

    @Override
    public Integer getHistorySize() {
        return (Integer)this.getProperty("historySize");
    }
}

