/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.converter;

import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.gwt.wysiwyg.client.cleaner.HTMLCleaner;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;

@Component
@Singleton
public class DefaultHTMLConverter
implements HTMLConverter {
    @Inject
    private Logger logger;
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    @Named(value="xhtml/1.0")
    private Parser xhtmlParser;
    @Inject
    @Named(value="xhtml/1.0")
    private StreamParser xhtmlStreamParser;
    @Inject
    private SyntaxFactory syntaxFactory;
    @Inject
    @Named(value="macro")
    private Transformation macroTransformation;
    @Inject
    @Named(value="annotatedxhtml/1.0")
    private BlockRenderer xhtmlRenderer;
    @Inject
    private ComponentManager componentManager;

    public String fromHTML(String dirtyHTML, String syntaxId) {
        try {
            String html = this.htmlCleaner.clean(dirtyHTML);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRendererFactory printRendererFactory = (PrintRendererFactory)this.componentManager.lookup(PrintRendererFactory.class, syntaxId);
            this.xhtmlStreamParser.parse((Reader)new StringReader(html), (Listener)printRendererFactory.createRenderer((WikiPrinter)printer));
            return printer.toString();
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while parsing HTML", e);
        }
    }

    public String toHTML(String source, String syntaxId) {
        try {
            Parser parser = (Parser)this.componentManager.lookup(Parser.class, syntaxId);
            XDOM xdom = parser.parse((Reader)new StringReader(source));
            TransformationContext txContext = new TransformationContext();
            txContext.setXDOM(xdom);
            txContext.setSyntax(this.syntaxFactory.createSyntaxFromIdString(syntaxId));
            this.macroTransformation.transform((Block)xdom, txContext);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while rendering HTML", e);
        }
    }

    public String parseAndRender(String dirtyHTML, String syntaxId) {
        try {
            String html = this.htmlCleaner.clean(dirtyHTML);
            XDOM xdom = this.xhtmlParser.parse((Reader)new StringReader(html));
            Syntax syntax = this.syntaxFactory.createSyntaxFromIdString(syntaxId);
            xdom.getMetaData().addMetaData("syntax", (Object)syntax);
            TransformationContext txContext = new TransformationContext();
            txContext.setXDOM(xdom);
            txContext.setSyntax(syntax);
            this.macroTransformation.transform((Block)xdom, txContext);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while refreshing HTML", e);
        }
    }
}

