/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.sync;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.gwt.wysiwyg.client.diff.Diff;
import org.xwiki.gwt.wysiwyg.client.diff.DifferentiationFailedException;
import org.xwiki.gwt.wysiwyg.client.diff.PatchFailedException;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;
import org.xwiki.gwt.wysiwyg.client.diff.ToString;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncResult;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncStatus;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncTools;
import org.xwiki.wysiwyg.server.plugin.sync.SyncEngine;
import org.xwiki.wysiwyg.server.plugin.sync.SyncException;

@Component
@Singleton
public class DefaultSyncEngine
implements SyncEngine {
    @Inject
    private Logger logger;
    private Map<String, SyncStatus> syncMap = new HashMap<String, SyncStatus>();

    @Override
    public SyncStatus getSyncStatus(String key) {
        return this.syncMap.get(key);
    }

    @Override
    public void setSyncStatus(String key, SyncStatus syncStatus) {
        this.syncMap.put(key, syncStatus);
    }

    @Override
    public SyncResult sync(SyncStatus syncStatus, Revision revision, int version) throws SyncException {
        try {
            this.logger.debug("Current server version is [{}] ", (Object)syncStatus.getCurrentVersionNumber());
            this.logger.debug("Client version is [{}]", (Object)version);
            if (version == syncStatus.getCurrentVersionNumber()) {
                return this.maybeCommitRevision(syncStatus, revision, version);
            }
            return this.maybeRelocateRevision(syncStatus, revision, version);
        }
        catch (Exception e) {
            this.logger.error("Exception while processing sync", (Throwable)e);
            throw new SyncException("Sync Failed", e);
        }
    }

    private SyncResult maybeCommitRevision(SyncStatus syncStatus, Revision revision, int version) throws PatchFailedException {
        this.logger.debug("Nothing to apply from the server");
        if (revision == null) {
            this.logger.debug("Nothing to apply from the client");
            return null;
        }
        this.logger.debug("Applying patch from the client [{}]", (Object)revision);
        String originalContent = syncStatus.getVersion(version);
        this.logger.debug("Original content [{}]", (Object)originalContent);
        String newContent = ToString.arrayToString((Object[])revision.patch((Object[])ToString.stringToArray((String)originalContent)));
        this.logger.debug("New content [{}]", (Object)newContent);
        syncStatus.addVersion(newContent);
        SyncResult result = new SyncResult();
        result.setVersion(syncStatus.getCurrentVersionNumber());
        result.setRevision(null);
        result.setStatus(true);
        return result;
    }

    private SyncResult maybeRelocateRevision(SyncStatus syncStatus, Revision revision, int version) throws DifferentiationFailedException, PatchFailedException {
        Revision rev;
        String originalContent;
        String lastContent = syncStatus.getCurrentVersion();
        if (lastContent.equals(originalContent = syncStatus.getVersion(version))) {
            rev = null;
        } else {
            rev = Diff.diff((Object[])ToString.stringToArray((String)originalContent), (Object[])ToString.stringToArray((String)lastContent));
            this.logger.debug("Content on client is based on this content [{}]", (Object)originalContent);
            this.logger.debug("Clients needs to update it's content with rev [{}]", (Object)rev);
        }
        SyncResult result = new SyncResult();
        if (revision == null) {
            result.setVersion(syncStatus.getCurrentVersionNumber());
            result.setRevision(rev);
            result.setStatus(true);
            return result;
        }
        this.logger.debug("Original revision is [{}]", (Object)revision);
        this.logger.debug("Other revision is [{}]", (Object)rev);
        rev = rev == null ? revision : SyncTools.relocateRevision((Revision)revision, (Revision)rev);
        this.logger.debug("Relocated revision is [{}]", (Object)rev);
        this.logger.debug("Content being patched [{}]", (Object)lastContent);
        String newContent = ToString.arrayToString((Object[])rev.patch((Object[])ToString.stringToArray((String)lastContent)));
        this.logger.debug("New content is [{}]", (Object)newContent);
        Revision newRevision = Diff.diff((Object[])ToString.stringToArray((String)originalContent), (Object[])ToString.stringToArray((String)newContent));
        this.logger.debug("New revision to apply on the client [{}]", (Object)newRevision);
        syncStatus.addVersion(newContent);
        result.setVersion(syncStatus.getCurrentVersionNumber());
        result.setRevision(newRevision);
        result.setStatus(true);
        return result;
    }
}

