/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.sync;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncResult;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncService;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.wysiwyg.server.plugin.sync.SyncEngine;

@Component
@Singleton
public class XWikiSyncService
implements SyncService {
    @Inject
    private Logger logger;
    @Inject
    private SyncEngine syncEngine;
    @Inject
    private DocumentAccessBridge docAccessBridge;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private HTMLConverter htmlConverter;

    public synchronized SyncResult syncEditorContent(Revision revision, String pageName, int version, boolean syncReset) {
        try {
            SyncStatus syncStatus = this.syncEngine.getSyncStatus(pageName);
            if (syncStatus == null || syncReset) {
                DocumentReference docRef = this.documentReferenceResolver.resolve((Object)pageName, new Object[0]);
                DocumentModelBridge docModelBridge = this.docAccessBridge.getDocument(docRef);
                syncStatus = new SyncStatus(pageName, docModelBridge.getVersion(), this.getRenderedContent(docModelBridge));
                this.syncEngine.setSyncStatus(pageName, syncStatus);
            }
            return this.syncEngine.sync(syncStatus, revision, version);
        }
        catch (Exception e) {
            this.logger.error("Exception while synchronizing edited content.", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRenderedContent(DocumentModelBridge docModelBridge) throws Exception {
        HashMap backupObjects = new HashMap();
        try {
            this.docAccessBridge.pushDocumentInContext(backupObjects, docModelBridge.getDocumentReference());
            String string = this.htmlConverter.toHTML(docModelBridge.getContent(), docModelBridge.getSyntax().toIdString());
            return string;
        }
        finally {
            this.docAccessBridge.popDocumentFromContext(backupObjects);
        }
    }
}

