/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.wiki;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiService;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wysiwyg.server.wiki.EntityReferenceConverter;
import org.xwiki.wysiwyg.server.wiki.LinkService;

public abstract class AbstractWikiService
implements WikiService {
    protected final EntityReferenceConverter entityReferenceConverter = new EntityReferenceConverter();
    @Inject
    protected Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    private LinkService linkService;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private CSRFToken csrf;

    public List<String> getPageNames(String wikiName, String spaceName) {
        String statement = "select distinct doc.space, doc.name from XWikiDocument as doc where doc.space = :space order by doc.space, doc.name";
        Query query = this.createHQLQuery(statement);
        query.setWiki(wikiName).bindValue("space", (Object)spaceName);
        ArrayList<String> pagesNames = new ArrayList<String>();
        for (DocumentReference documentReference : this.searchDocumentReferences(query)) {
            pagesNames.add(documentReference.getName());
        }
        return pagesNames;
    }

    public List<WikiPage> getRecentlyModifiedPages(String wikiName, int offset, int limit) {
        String statement = "select distinct doc.space, doc.name, doc.date from XWikiDocument as doc where doc.author = :author order by doc.date desc, doc.space, doc.name";
        Query query = this.createHQLQuery(statement);
        query.setWiki(wikiName).setOffset(offset).setLimit(limit);
        query.bindValue("author", (Object)this.getCurrentUserRelativeTo(wikiName));
        return this.getWikiPages(this.searchDocumentReferences(query));
    }

    protected abstract String getCurrentUserRelativeTo(String var1);

    public List<WikiPage> getMatchingPages(String wikiName, String keyword, int offset, int limit) {
        StringBuilder statement = new StringBuilder();
        statement.append("select distinct doc.space, doc.name from XWikiDocument as doc where ");
        List<String> blackListedSpaces = this.getBlackListedSpaces();
        if (!blackListedSpaces.isEmpty()) {
            for (int i = 0; i < blackListedSpaces.size(); ++i) {
                statement.append(i == 0 ? "doc.space not in (" : ",");
                statement.append(":bSpace").append(i);
            }
            statement.append(") and ");
        }
        statement.append("(lower(doc.title) like '%'||:keyword||'%' or lower(doc.fullName) like '%'||:keyword||'%')");
        statement.append(" order by doc.space, doc.name");
        Query query = this.createHQLQuery(statement.toString());
        query.setWiki(wikiName).setOffset(offset).setLimit(limit);
        query.bindValue("keyword", (Object)keyword.toLowerCase());
        for (int i = 0; i < blackListedSpaces.size(); ++i) {
            query.bindValue("bSpace" + i, (Object)blackListedSpaces.get(i));
        }
        return this.getWikiPages(this.searchDocumentReferences(query));
    }

    private Query createHQLQuery(String statement) {
        try {
            return this.queryManager.createQuery(statement, "hql");
        }
        catch (QueryException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract List<String> getBlackListedSpaces();

    protected abstract List<WikiPage> getWikiPages(List<DocumentReference> var1);

    private List<DocumentReference> searchDocumentReferences(Query query) {
        try {
            ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
            List results = query.execute();
            for (Object[] result : results) {
                documentReferences.add(new DocumentReference(query.getWiki(), (String)result[0], (String)result[1]));
            }
            return documentReferences;
        }
        catch (QueryException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityConfig getEntityConfig(EntityReference origin, ResourceReference destination) {
        return this.linkService.getEntityConfig(origin, destination);
    }

    public ResourceReference parseLinkReference(String linkReference, EntityReference baseReference) {
        return this.linkService.parseLinkReference(linkReference, baseReference);
    }

    public Attachment getAttachment(AttachmentReference clientAttachmentReference) {
        org.xwiki.model.reference.AttachmentReference attachmentReference = this.entityReferenceConverter.convert(clientAttachmentReference);
        try {
            if (StringUtils.isBlank((CharSequence)this.documentAccessBridge.getAttachmentVersion(attachmentReference))) {
                this.logger.warn("Failed to get attachment: [{}] not found.", (Object)attachmentReference.getName());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get attachment: there was a problem with getting the document on the server.", (Throwable)e);
            return null;
        }
        Attachment attach = new Attachment();
        attach.setReference(clientAttachmentReference.getEntityReference());
        attach.setUrl(this.documentAccessBridge.getAttachmentURL(attachmentReference, false));
        return attach;
    }

    public List<Attachment> getImageAttachments(WikiPageReference reference) {
        ArrayList<Attachment> imageAttachments = new ArrayList<Attachment>();
        List allAttachments = this.getAttachments(reference);
        for (Attachment attachment : allAttachments) {
            if (!attachment.getMimeType().startsWith("image/")) continue;
            imageAttachments.add(attachment);
        }
        return imageAttachments;
    }

    public String getUploadURL(WikiPageReference reference) {
        String queryString = "form_token=" + this.csrf.getToken();
        return this.documentAccessBridge.getDocumentURL(this.entityReferenceConverter.convert(reference), "upload", queryString, null);
    }
}

