/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wysiwyg.server.plugin.macro;

import org.xwiki.component.annotation.Role;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor;

/**
 * Translates a {@link MacroDescriptor} into the execution context language.
 * 
 * @version $Id: 13c11de39f421b6d66d0c3603237614a86480415 $
 */
@Role
public interface MacroDescriptorTranslator
{
    /**
     * Translates the given macro descriptor into the execution context language.
     * 
     * @param macroDescriptor a macro descriptor
     * @return the given macro descriptor translated into the execution context language
     */
    MacroDescriptor translate(MacroDescriptor macroDescriptor);
}
