/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.macro;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroService;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterType;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroCategoryManager;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.wysiwyg.server.plugin.macro.MacroDescriptorTranslator;

@Component
@Singleton
public class XWikiMacroService
implements MacroService {
    @Inject
    private SyntaxFactory syntaxFactory;
    @Inject
    private MacroManager macroManager;
    @Inject
    private MacroCategoryManager categoryManager;
    @Inject
    private MacroDescriptorTranslator macroDescriptorTranslator;

    public org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor getMacroDescriptor(String macroId, String syntaxId) {
        return this.macroDescriptorTranslator.translate(this.getUntranslatedMacroDescriptor(macroId, syntaxId));
    }

    private org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor getUntranslatedMacroDescriptor(String macroId, String syntaxId) {
        try {
            MacroId macroIdObject = new MacroId(macroId, this.syntaxFactory.createSyntaxFromIdString(syntaxId));
            Macro macro = this.macroManager.getMacro(macroIdObject);
            MacroDescriptor descriptor = macro.getDescriptor();
            org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor contentDescriptor = null;
            if (descriptor.getContentDescriptor() != null) {
                contentDescriptor = new org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor();
                contentDescriptor.setId("content");
                contentDescriptor.setName("Content");
                contentDescriptor.setDescription(descriptor.getContentDescriptor().getDescription());
                contentDescriptor.setType(this.createMacroParameterType((Type)((Object)StringBuffer.class)));
                contentDescriptor.setMandatory(descriptor.getContentDescriptor().isMandatory());
            }
            LinkedHashMap parameterDescriptorMap = new LinkedHashMap();
            for (Map.Entry entry : descriptor.getParameterDescriptorMap().entrySet()) {
                parameterDescriptorMap.put(entry.getKey(), this.createMacroParameterDescriptor((ParameterDescriptor)entry.getValue()));
            }
            org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor result = new org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor();
            result.setId(macroIdObject.getId());
            result.setName(descriptor.getName());
            result.setDescription(descriptor.getDescription());
            result.setSupportingInlineMode(macro.supportsInlineMode());
            result.setContentDescriptor(contentDescriptor);
            result.setParameterDescriptorMap(parameterDescriptorMap);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while retrieving macro descriptor.", e);
        }
    }

    private org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor createMacroParameterDescriptor(ParameterDescriptor descriptor) {
        org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor result = new org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor();
        result.setId(descriptor.getId());
        result.setName(StringUtils.isBlank((CharSequence)descriptor.getName()) ? descriptor.getId() : descriptor.getName());
        result.setDescription(descriptor.getDescription());
        result.setType(this.createMacroParameterType(descriptor.getParameterType()));
        Object defaultValue = descriptor.getDefaultValue();
        if (defaultValue != null) {
            result.setDefaultValue(String.valueOf(defaultValue));
        }
        result.setMandatory(descriptor.isMandatory());
        return result;
    }

    private ParameterType createMacroParameterType(Type type) {
        ParameterType parameterType = new ParameterType();
        if (type instanceof Class) {
            Class parameterClass = (Class)type;
            parameterType.setName(parameterClass.getName());
            if (parameterClass.isEnum()) {
                T[] parameterClassConstants = parameterClass.getEnumConstants();
                LinkedHashMap<String, String> parameterTypeConstants = new LinkedHashMap<String, String>();
                for (int i = 0; i < parameterClassConstants.length; ++i) {
                    String constant = String.valueOf(parameterClassConstants[i]);
                    parameterTypeConstants.put(constant, constant);
                }
                parameterType.setEnumConstants(parameterTypeConstants);
            }
        }
        return parameterType;
    }

    public List<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor> getMacroDescriptors(String syntaxId) {
        try {
            Syntax syntax = this.syntaxFactory.createSyntaxFromIdString(syntaxId);
            ArrayList<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor> descriptors = new ArrayList<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor>();
            for (String category : this.categoryManager.getMacroCategories(syntax)) {
                for (MacroId macroId : this.categoryManager.getMacroIds(category, syntax)) {
                    org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor descriptor = this.getUntranslatedMacroDescriptor(macroId.getId(), syntaxId);
                    descriptor.setCategory(category);
                    descriptors.add(this.macroDescriptorTranslator.translate(descriptor));
                }
            }
            Collections.sort(descriptors, new Comparator<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor>(){

                @Override
                public int compare(org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor alice, org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor bob) {
                    return alice.getName().compareTo(bob.getName());
                }
            });
            return descriptors;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while retrieving the list of macro descriptors for syntax [" + syntaxId + "].", e);
        }
    }
}

